package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedTagEventList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedTagEventListAssert<S extends AbstractNamedTagEventListAssert<S, A>, A extends NamedTagEventList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedTagEventListAssert}</code> to make assertions on actual NamedTagEventList.
   * @param actual the NamedTagEventList we want to make assertions on.
   */
  protected AbstractNamedTagEventListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedTagEventList's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedTagEventList's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagEventList's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedTagEventList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventList's items contains the given TagEvent elements.
   * @param items the given elements that should be contained in actual NamedTagEventList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventList's items does not contain all given TagEvent elements.
   */
  public S hasItems(TagEvent... items) {
    // check that actual NamedTagEventList we want to make assertions on is not null.
    isNotNull();

    // check that given TagEvent varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventList has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventList's items is not empty.
   */
  public S hasNoItems() {
    // check that actual NamedTagEventList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NamedTagEventList's tag is equal to the given one.
   * @param tag the given tag to compare the actual NamedTagEventList's tag to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagEventList's tag is not equal to the given one.
   */
  public S hasTag(String tag) {
    // check that actual NamedTagEventList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected tag of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTag = actual.getTag();
    if (!Objects.areEqual(actualTag, tag)) {
      failWithMessage(assertjErrorMessage, actual, tag, actualTag);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
