package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PolicyBinding} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPolicyBindingAssert<S extends AbstractPolicyBindingAssert<S, A>, A extends PolicyBinding> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPolicyBindingAssert}</code> to make assertions on actual PolicyBinding.
   * @param actual the PolicyBinding we want to make assertions on.
   */
  protected AbstractPolicyBindingAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PolicyBinding's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PolicyBinding's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyBinding's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyBinding's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual PolicyBinding's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyBinding's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(PolicyBinding.ApiVersion apiVersion) {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PolicyBinding.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyBinding's kind is equal to the given one.
   * @param kind the given kind to compare the actual PolicyBinding's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyBinding's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyBinding's lastModified is equal to the given one.
   * @param lastModified the given lastModified to compare the actual PolicyBinding's lastModified to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyBinding's lastModified is not equal to the given one.
   */
  public S hasLastModified(String lastModified) {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected lastModified of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastModified = actual.getLastModified();
    if (!Objects.areEqual(actualLastModified, lastModified)) {
      failWithMessage(assertjErrorMessage, actual, lastModified, actualLastModified);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyBinding's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual PolicyBinding's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyBinding's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyBinding's policyRef is equal to the given one.
   * @param policyRef the given policyRef to compare the actual PolicyBinding's policyRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyBinding's policyRef is not equal to the given one.
   */
  public S hasPolicyRef(io.fabric8.kubernetes.api.model.ObjectReference policyRef) {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected policyRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualPolicyRef = actual.getPolicyRef();
    if (!Objects.areEqual(actualPolicyRef, policyRef)) {
      failWithMessage(assertjErrorMessage, actual, policyRef, actualPolicyRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyBinding's roleBindings contains the given NamedRoleBinding elements.
   * @param roleBindings the given elements that should be contained in actual PolicyBinding's roleBindings.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyBinding's roleBindings does not contain all given NamedRoleBinding elements.
   */
  public S hasRoleBindings(NamedRoleBinding... roleBindings) {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // check that given NamedRoleBinding varargs is not null.
    if (roleBindings == null) throw new AssertionError("Expecting roleBindings parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRoleBindings(), roleBindings);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyBinding has no roleBindings.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyBinding's roleBindings is not empty.
   */
  public S hasNoRoleBindings() {
    // check that actual PolicyBinding we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have roleBindings but had :\n  <%s>";
    
    // check
    if (actual.getRoleBindings().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRoleBindings());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
