package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BindingFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBindingFluentImplAssert<S extends AbstractBindingFluentImplAssert<S, A>, A extends BindingFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBindingFluentImplAssert}</code> to make assertions on actual BindingFluentImpl.
   * @param actual the BindingFluentImpl we want to make assertions on.
   */
  protected AbstractBindingFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BindingFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BindingFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BindingFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BindingFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual BindingFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BindingFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Binding.ApiVersion apiVersion) {
    // check that actual BindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Binding.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BindingFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual BindingFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BindingFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual BindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BindingFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual BindingFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BindingFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual BindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BindingFluentImpl's target is equal to the given one.
   * @param target the given target to compare the actual BindingFluentImpl's target to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BindingFluentImpl's target is not equal to the given one.
   */
  public S hasTarget(ObjectReference target) {
    // check that actual BindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting target of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectReference actualTarget = actual.getTarget();
    if (!Objects.areEqual(actualTarget, target)) {
      failWithMessage(assertjErrorMessage, actual, target, actualTarget);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
