package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerFluentImplAssert<S extends AbstractContainerFluentImplAssert<S, A>, A extends ContainerFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerFluentImplAssert}</code> to make assertions on actual ContainerFluentImpl.
   * @param actual the ContainerFluentImpl we want to make assertions on.
   */
  protected AbstractContainerFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's args contains the given String elements.
   * @param args the given elements that should be contained in actual ContainerFluentImpl's args.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's args does not contain all given String elements.
   */
  public S hasArgs(String... args) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (args == null) failWithMessage("Expecting args parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getArgs(), args);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's args contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param args the given elements that should be contained in actual ContainerFluentImpl's args.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's args does not contain all given String elements.
   */
  public S hasOnlyArgs(String... args) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (args == null) failWithMessage("Expecting args parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getArgs(), args);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's args does not contain the given String elements.
   *
   * @param args the given elements that should not be in actual ContainerFluentImpl's args.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's args contains any given String elements.
   */
  public S doesNotHaveArgs(String... args) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (args == null) failWithMessage("Expecting args parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getArgs(), args);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl has no args.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's args is not empty.
   */
  public S hasNoArgs() {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have args but had :\n  <%s>";
    
    // check
    if (actual.getArgs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getArgs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerFluentImpl's command contains the given String elements.
   * @param command the given elements that should be contained in actual ContainerFluentImpl's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's command contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param command the given elements that should be contained in actual ContainerFluentImpl's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's command does not contain all given String elements.
   */
  public S hasOnlyCommand(String... command) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's command does not contain the given String elements.
   *
   * @param command the given elements that should not be in actual ContainerFluentImpl's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's command contains any given String elements.
   */
  public S doesNotHaveCommand(String... command) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerFluentImpl's env contains the given EnvVar elements.
   * @param env the given elements that should be contained in actual ContainerFluentImpl's env.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's env does not contain all given EnvVar elements.
   */
  public S hasEnv(EnvVar... env) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's env contains <b>only<b> the given EnvVar elements and nothing else in whatever order.
   * @param env the given elements that should be contained in actual ContainerFluentImpl's env.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's env does not contain all given EnvVar elements.
   */
  public S hasOnlyEnv(EnvVar... env) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's env does not contain the given EnvVar elements.
   *
   * @param env the given elements that should not be in actual ContainerFluentImpl's env.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's env contains any given EnvVar elements.
   */
  public S doesNotHaveEnv(EnvVar... env) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerFluentImpl's image is equal to the given one.
   * @param image the given image to compare the actual ContainerFluentImpl's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's imagePullPolicy is equal to the given one.
   * @param imagePullPolicy the given imagePullPolicy to compare the actual ContainerFluentImpl's imagePullPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's imagePullPolicy is not equal to the given one.
   */
  public S hasImagePullPolicy(String imagePullPolicy) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting imagePullPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImagePullPolicy = actual.getImagePullPolicy();
    if (!Objects.areEqual(actualImagePullPolicy, imagePullPolicy)) {
      failWithMessage(assertjErrorMessage, actual, imagePullPolicy, actualImagePullPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's lifecycle is equal to the given one.
   * @param lifecycle the given lifecycle to compare the actual ContainerFluentImpl's lifecycle to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's lifecycle is not equal to the given one.
   */
  public S hasLifecycle(Lifecycle lifecycle) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lifecycle of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Lifecycle actualLifecycle = actual.getLifecycle();
    if (!Objects.areEqual(actualLifecycle, lifecycle)) {
      failWithMessage(assertjErrorMessage, actual, lifecycle, actualLifecycle);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's livenessProbe is equal to the given one.
   * @param livenessProbe the given livenessProbe to compare the actual ContainerFluentImpl's livenessProbe to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's livenessProbe is not equal to the given one.
   */
  public S hasLivenessProbe(Probe livenessProbe) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting livenessProbe of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Probe actualLivenessProbe = actual.getLivenessProbe();
    if (!Objects.areEqual(actualLivenessProbe, livenessProbe)) {
      failWithMessage(assertjErrorMessage, actual, livenessProbe, actualLivenessProbe);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual ContainerFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's ports contains the given ContainerPort elements.
   * @param ports the given elements that should be contained in actual ContainerFluentImpl's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's ports does not contain all given ContainerPort elements.
   */
  public S hasPorts(ContainerPort... ports) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerPort varargs is not null.
    if (ports == null) failWithMessage("Expecting ports parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's ports contains <b>only<b> the given ContainerPort elements and nothing else in whatever order.
   * @param ports the given elements that should be contained in actual ContainerFluentImpl's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's ports does not contain all given ContainerPort elements.
   */
  public S hasOnlyPorts(ContainerPort... ports) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerPort varargs is not null.
    if (ports == null) failWithMessage("Expecting ports parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's ports does not contain the given ContainerPort elements.
   *
   * @param ports the given elements that should not be in actual ContainerFluentImpl's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's ports contains any given ContainerPort elements.
   */
  public S doesNotHavePorts(ContainerPort... ports) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerPort varargs is not null.
    if (ports == null) failWithMessage("Expecting ports parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl has no ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's ports is not empty.
   */
  public S hasNoPorts() {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have ports but had :\n  <%s>";
    
    // check
    if (actual.getPorts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPorts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerFluentImpl's readinessProbe is equal to the given one.
   * @param readinessProbe the given readinessProbe to compare the actual ContainerFluentImpl's readinessProbe to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's readinessProbe is not equal to the given one.
   */
  public S hasReadinessProbe(Probe readinessProbe) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readinessProbe of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Probe actualReadinessProbe = actual.getReadinessProbe();
    if (!Objects.areEqual(actualReadinessProbe, readinessProbe)) {
      failWithMessage(assertjErrorMessage, actual, readinessProbe, actualReadinessProbe);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's resources is equal to the given one.
   * @param resources the given resources to compare the actual ContainerFluentImpl's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's resources is not equal to the given one.
   */
  public S hasResources(ResourceRequirements resources) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ResourceRequirements actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's securityContext is equal to the given one.
   * @param securityContext the given securityContext to compare the actual ContainerFluentImpl's securityContext to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's securityContext is not equal to the given one.
   */
  public S hasSecurityContext(SecurityContext securityContext) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting securityContext of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContext actualSecurityContext = actual.getSecurityContext();
    if (!Objects.areEqual(actualSecurityContext, securityContext)) {
      failWithMessage(assertjErrorMessage, actual, securityContext, actualSecurityContext);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's terminationMessagePath is equal to the given one.
   * @param terminationMessagePath the given terminationMessagePath to compare the actual ContainerFluentImpl's terminationMessagePath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's terminationMessagePath is not equal to the given one.
   */
  public S hasTerminationMessagePath(String terminationMessagePath) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting terminationMessagePath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTerminationMessagePath = actual.getTerminationMessagePath();
    if (!Objects.areEqual(actualTerminationMessagePath, terminationMessagePath)) {
      failWithMessage(assertjErrorMessage, actual, terminationMessagePath, actualTerminationMessagePath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's volumeMounts contains the given VolumeMount elements.
   * @param volumeMounts the given elements that should be contained in actual ContainerFluentImpl's volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's volumeMounts does not contain all given VolumeMount elements.
   */
  public S hasVolumeMounts(VolumeMount... volumeMounts) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given VolumeMount varargs is not null.
    if (volumeMounts == null) failWithMessage("Expecting volumeMounts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVolumeMounts(), volumeMounts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's volumeMounts contains <b>only<b> the given VolumeMount elements and nothing else in whatever order.
   * @param volumeMounts the given elements that should be contained in actual ContainerFluentImpl's volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's volumeMounts does not contain all given VolumeMount elements.
   */
  public S hasOnlyVolumeMounts(VolumeMount... volumeMounts) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given VolumeMount varargs is not null.
    if (volumeMounts == null) failWithMessage("Expecting volumeMounts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getVolumeMounts(), volumeMounts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl's volumeMounts does not contain the given VolumeMount elements.
   *
   * @param volumeMounts the given elements that should not be in actual ContainerFluentImpl's volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's volumeMounts contains any given VolumeMount elements.
   */
  public S doesNotHaveVolumeMounts(VolumeMount... volumeMounts) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given VolumeMount varargs is not null.
    if (volumeMounts == null) failWithMessage("Expecting volumeMounts parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getVolumeMounts(), volumeMounts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerFluentImpl has no volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerFluentImpl's volumeMounts is not empty.
   */
  public S hasNoVolumeMounts() {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have volumeMounts but had :\n  <%s>";
    
    // check
    if (actual.getVolumeMounts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVolumeMounts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerFluentImpl's workingDir is equal to the given one.
   * @param workingDir the given workingDir to compare the actual ContainerFluentImpl's workingDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerFluentImpl's workingDir is not equal to the given one.
   */
  public S hasWorkingDir(String workingDir) {
    // check that actual ContainerFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workingDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualWorkingDir = actual.getWorkingDir();
    if (!Objects.areEqual(actualWorkingDir, workingDir)) {
      failWithMessage(assertjErrorMessage, actual, workingDir, actualWorkingDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
