package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link FSGroupStrategyOptionsFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractFSGroupStrategyOptionsFluentAssert<S extends AbstractFSGroupStrategyOptionsFluentAssert<S, A>, A extends FSGroupStrategyOptionsFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractFSGroupStrategyOptionsFluentAssert}</code> to make assertions on actual FSGroupStrategyOptionsFluent.
   * @param actual the FSGroupStrategyOptionsFluent we want to make assertions on.
   */
  protected AbstractFSGroupStrategyOptionsFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual FSGroupStrategyOptionsFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual FSGroupStrategyOptionsFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FSGroupStrategyOptionsFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual FSGroupStrategyOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FSGroupStrategyOptionsFluent's ranges contains the given IDRange elements.
   * @param ranges the given elements that should be contained in actual FSGroupStrategyOptionsFluent's ranges.
   * @return this assertion object.
   * @throws AssertionError if the actual FSGroupStrategyOptionsFluent's ranges does not contain all given IDRange elements.
   */
  public S hasRanges(IDRange... ranges) {
    // check that actual FSGroupStrategyOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IDRange varargs is not null.
    if (ranges == null) failWithMessage("Expecting ranges parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRanges(), ranges);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FSGroupStrategyOptionsFluent's ranges contains <b>only<b> the given IDRange elements and nothing else in whatever order.
   * @param ranges the given elements that should be contained in actual FSGroupStrategyOptionsFluent's ranges.
   * @return this assertion object.
   * @throws AssertionError if the actual FSGroupStrategyOptionsFluent's ranges does not contain all given IDRange elements.
   */
  public S hasOnlyRanges(IDRange... ranges) {
    // check that actual FSGroupStrategyOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IDRange varargs is not null.
    if (ranges == null) failWithMessage("Expecting ranges parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getRanges(), ranges);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FSGroupStrategyOptionsFluent's ranges does not contain the given IDRange elements.
   *
   * @param ranges the given elements that should not be in actual FSGroupStrategyOptionsFluent's ranges.
   * @return this assertion object.
   * @throws AssertionError if the actual FSGroupStrategyOptionsFluent's ranges contains any given IDRange elements.
   */
  public S doesNotHaveRanges(IDRange... ranges) {
    // check that actual FSGroupStrategyOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IDRange varargs is not null.
    if (ranges == null) failWithMessage("Expecting ranges parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getRanges(), ranges);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FSGroupStrategyOptionsFluent has no ranges.
   * @return this assertion object.
   * @throws AssertionError if the actual FSGroupStrategyOptionsFluent's ranges is not empty.
   */
  public S hasNoRanges() {
    // check that actual FSGroupStrategyOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have ranges but had :\n  <%s>";
    
    // check
    if (actual.getRanges().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRanges());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual FSGroupStrategyOptionsFluent's type is equal to the given one.
   * @param type the given type to compare the actual FSGroupStrategyOptionsFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FSGroupStrategyOptionsFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual FSGroupStrategyOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
