package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GitRepoVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGitRepoVolumeSourceAssert<S extends AbstractGitRepoVolumeSourceAssert<S, A>, A extends GitRepoVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGitRepoVolumeSourceAssert}</code> to make assertions on actual GitRepoVolumeSource.
   * @param actual the GitRepoVolumeSource we want to make assertions on.
   */
  protected AbstractGitRepoVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GitRepoVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GitRepoVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitRepoVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GitRepoVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitRepoVolumeSource's repository is equal to the given one.
   * @param repository the given repository to compare the actual GitRepoVolumeSource's repository to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitRepoVolumeSource's repository is not equal to the given one.
   */
  public S hasRepository(String repository) {
    // check that actual GitRepoVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting repository of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRepository = actual.getRepository();
    if (!Objects.areEqual(actualRepository, repository)) {
      failWithMessage(assertjErrorMessage, actual, repository, actualRepository);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitRepoVolumeSource's revision is equal to the given one.
   * @param revision the given revision to compare the actual GitRepoVolumeSource's revision to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitRepoVolumeSource's revision is not equal to the given one.
   */
  public S hasRevision(String revision) {
    // check that actual GitRepoVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revision of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRevision = actual.getRevision();
    if (!Objects.areEqual(actualRevision, revision)) {
      failWithMessage(assertjErrorMessage, actual, revision, actualRevision);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
