package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IDRangeFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIDRangeFluentImplAssert<S extends AbstractIDRangeFluentImplAssert<S, A>, A extends IDRangeFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIDRangeFluentImplAssert}</code> to make assertions on actual IDRangeFluentImpl.
   * @param actual the IDRangeFluentImpl we want to make assertions on.
   */
  protected AbstractIDRangeFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IDRangeFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IDRangeFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IDRangeFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IDRangeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IDRangeFluentImpl's max is equal to the given one.
   * @param max the given max to compare the actual IDRangeFluentImpl's max to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IDRangeFluentImpl's max is not equal to the given one.
   */
  public S hasMax(Long max) {
    // check that actual IDRangeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting max of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualMax = actual.getMax();
    if (!Objects.areEqual(actualMax, max)) {
      failWithMessage(assertjErrorMessage, actual, max, actualMax);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IDRangeFluentImpl's min is equal to the given one.
   * @param min the given min to compare the actual IDRangeFluentImpl's min to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IDRangeFluentImpl's min is not equal to the given one.
   */
  public S hasMin(Long min) {
    // check that actual IDRangeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting min of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualMin = actual.getMin();
    if (!Objects.areEqual(actualMin, min)) {
      failWithMessage(assertjErrorMessage, actual, min, actualMin);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
