package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KubernetesResourceList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesResourceListAssert<S extends AbstractKubernetesResourceListAssert<S, A>, A extends KubernetesResourceList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesResourceListAssert}</code> to make assertions on actual KubernetesResourceList.
   * @param actual the KubernetesResourceList we want to make assertions on.
   */
  protected AbstractKubernetesResourceListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubernetesResourceList's items contains the given HasMetadata elements.
   * @param items the given elements that should be contained in actual KubernetesResourceList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesResourceList's items does not contain all given HasMetadata elements.
   */
  public S hasItems(HasMetadata... items) {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // check that given HasMetadata varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesResourceList's items contains <b>only<b> the given HasMetadata elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual KubernetesResourceList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesResourceList's items does not contain all given HasMetadata elements.
   */
  public S hasOnlyItems(HasMetadata... items) {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // check that given HasMetadata varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesResourceList's items does not contain the given HasMetadata elements.
   *
   * @param items the given elements that should not be in actual KubernetesResourceList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesResourceList's items contains any given HasMetadata elements.
   */
  public S doesNotHaveItems(HasMetadata... items) {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // check that given HasMetadata varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesResourceList has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesResourceList's items is not empty.
   */
  public S hasNoItems() {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesResourceList's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual KubernetesResourceList's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesResourceList's metadata is not equal to the given one.
   */
  public S hasMetadata(ListMeta metadata) {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ListMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
