package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ReplicationControllerSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicationControllerSpecFluentAssert<S extends AbstractReplicationControllerSpecFluentAssert<S, A>, A extends ReplicationControllerSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicationControllerSpecFluentAssert}</code> to make assertions on actual ReplicationControllerSpecFluent.
   * @param actual the ReplicationControllerSpecFluent we want to make assertions on.
   */
  protected AbstractReplicationControllerSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ReplicationControllerSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ReplicationControllerSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ReplicationControllerSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerSpecFluent's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ReplicationControllerSpecFluent's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpecFluent's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ReplicationControllerSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerSpecFluent's selector is equal to the given one.
   * @param selector the given selector to compare the actual ReplicationControllerSpecFluent's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpecFluent's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual ReplicationControllerSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerSpecFluent's template is equal to the given one.
   * @param template the given template to compare the actual ReplicationControllerSpecFluent's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpecFluent's template is not equal to the given one.
   */
  public S hasTemplate(PodTemplateSpec template) {
    // check that actual ReplicationControllerSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
