package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RootPathsFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRootPathsFluentImplAssert<S extends AbstractRootPathsFluentImplAssert<S, A>, A extends RootPathsFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRootPathsFluentImplAssert}</code> to make assertions on actual RootPathsFluentImpl.
   * @param actual the RootPathsFluentImpl we want to make assertions on.
   */
  protected AbstractRootPathsFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RootPathsFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RootPathsFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RootPathsFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RootPathsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RootPathsFluentImpl's paths contains the given String elements.
   * @param paths the given elements that should be contained in actual RootPathsFluentImpl's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual RootPathsFluentImpl's paths does not contain all given String elements.
   */
  public S hasPaths(String... paths) {
    // check that actual RootPathsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RootPathsFluentImpl's paths contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param paths the given elements that should be contained in actual RootPathsFluentImpl's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual RootPathsFluentImpl's paths does not contain all given String elements.
   */
  public S hasOnlyPaths(String... paths) {
    // check that actual RootPathsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RootPathsFluentImpl's paths does not contain the given String elements.
   *
   * @param paths the given elements that should not be in actual RootPathsFluentImpl's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual RootPathsFluentImpl's paths contains any given String elements.
   */
  public S doesNotHavePaths(String... paths) {
    // check that actual RootPathsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RootPathsFluentImpl has no paths.
   * @return this assertion object.
   * @throws AssertionError if the actual RootPathsFluentImpl's paths is not empty.
   */
  public S hasNoPaths() {
    // check that actual RootPathsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have paths but had :\n  <%s>";
    
    // check
    if (actual.getPaths().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPaths());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
