package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecurityContextFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextFluentImplAssert<S extends AbstractSecurityContextFluentImplAssert<S, A>, A extends SecurityContextFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextFluentImplAssert}</code> to make assertions on actual SecurityContextFluentImpl.
   * @param actual the SecurityContextFluentImpl we want to make assertions on.
   */
  protected AbstractSecurityContextFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecurityContextFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecurityContextFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecurityContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextFluentImpl's capabilities is equal to the given one.
   * @param capabilities the given capabilities to compare the actual SecurityContextFluentImpl's capabilities to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluentImpl's capabilities is not equal to the given one.
   */
  public S hasCapabilities(Capabilities capabilities) {
    // check that actual SecurityContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting capabilities of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Capabilities actualCapabilities = actual.getCapabilities();
    if (!Objects.areEqual(actualCapabilities, capabilities)) {
      failWithMessage(assertjErrorMessage, actual, capabilities, actualCapabilities);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextFluentImpl's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual SecurityContextFluentImpl's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluentImpl's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(Long runAsUser) {
    // check that actual SecurityContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextFluentImpl's seLinuxOptions is equal to the given one.
   * @param seLinuxOptions the given seLinuxOptions to compare the actual SecurityContextFluentImpl's seLinuxOptions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluentImpl's seLinuxOptions is not equal to the given one.
   */
  public S hasSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    // check that actual SecurityContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting seLinuxOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxOptions actualSeLinuxOptions = actual.getSeLinuxOptions();
    if (!Objects.areEqual(actualSeLinuxOptions, seLinuxOptions)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxOptions, actualSeLinuxOptions);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
