package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VolumeMountFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeMountFluentAssert<S extends AbstractVolumeMountFluentAssert<S, A>, A extends VolumeMountFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeMountFluentAssert}</code> to make assertions on actual VolumeMountFluent.
   * @param actual the VolumeMountFluent we want to make assertions on.
   */
  protected AbstractVolumeMountFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VolumeMountFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual VolumeMountFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeMountFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual VolumeMountFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeMountFluent's mountPath is equal to the given one.
   * @param mountPath the given mountPath to compare the actual VolumeMountFluent's mountPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeMountFluent's mountPath is not equal to the given one.
   */
  public S hasMountPath(String mountPath) {
    // check that actual VolumeMountFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting mountPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMountPath = actual.getMountPath();
    if (!Objects.areEqual(actualMountPath, mountPath)) {
      failWithMessage(assertjErrorMessage, actual, mountPath, actualMountPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeMountFluent's name is equal to the given one.
   * @param name the given name to compare the actual VolumeMountFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeMountFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual VolumeMountFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
