package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DaemonSetStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetStatusFluentImplAssert<S extends AbstractDaemonSetStatusFluentImplAssert<S, A>, A extends DaemonSetStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetStatusFluentImplAssert}</code> to make assertions on actual DaemonSetStatusFluentImpl.
   * @param actual the DaemonSetStatusFluentImpl we want to make assertions on.
   */
  protected AbstractDaemonSetStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DaemonSetStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DaemonSetStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DaemonSetStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatusFluentImpl's currentNumberScheduled is equal to the given one.
   * @param currentNumberScheduled the given currentNumberScheduled to compare the actual DaemonSetStatusFluentImpl's currentNumberScheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatusFluentImpl's currentNumberScheduled is not equal to the given one.
   */
  public S hasCurrentNumberScheduled(Integer currentNumberScheduled) {
    // check that actual DaemonSetStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting currentNumberScheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCurrentNumberScheduled = actual.getCurrentNumberScheduled();
    if (!Objects.areEqual(actualCurrentNumberScheduled, currentNumberScheduled)) {
      failWithMessage(assertjErrorMessage, actual, currentNumberScheduled, actualCurrentNumberScheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatusFluentImpl's desiredNumberScheduled is equal to the given one.
   * @param desiredNumberScheduled the given desiredNumberScheduled to compare the actual DaemonSetStatusFluentImpl's desiredNumberScheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatusFluentImpl's desiredNumberScheduled is not equal to the given one.
   */
  public S hasDesiredNumberScheduled(Integer desiredNumberScheduled) {
    // check that actual DaemonSetStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting desiredNumberScheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDesiredNumberScheduled = actual.getDesiredNumberScheduled();
    if (!Objects.areEqual(actualDesiredNumberScheduled, desiredNumberScheduled)) {
      failWithMessage(assertjErrorMessage, actual, desiredNumberScheduled, actualDesiredNumberScheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatusFluentImpl's numberMisscheduled is equal to the given one.
   * @param numberMisscheduled the given numberMisscheduled to compare the actual DaemonSetStatusFluentImpl's numberMisscheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatusFluentImpl's numberMisscheduled is not equal to the given one.
   */
  public S hasNumberMisscheduled(Integer numberMisscheduled) {
    // check that actual DaemonSetStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting numberMisscheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualNumberMisscheduled = actual.getNumberMisscheduled();
    if (!Objects.areEqual(actualNumberMisscheduled, numberMisscheduled)) {
      failWithMessage(assertjErrorMessage, actual, numberMisscheduled, actualNumberMisscheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
