package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HorizontalPodAutoscalerStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHorizontalPodAutoscalerStatusAssert<S extends AbstractHorizontalPodAutoscalerStatusAssert<S, A>, A extends HorizontalPodAutoscalerStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHorizontalPodAutoscalerStatusAssert}</code> to make assertions on actual HorizontalPodAutoscalerStatus.
   * @param actual the HorizontalPodAutoscalerStatus we want to make assertions on.
   */
  protected AbstractHorizontalPodAutoscalerStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HorizontalPodAutoscalerStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HorizontalPodAutoscalerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerStatus's currentCPUUtilizationPercentage is equal to the given one.
   * @param currentCPUUtilizationPercentage the given currentCPUUtilizationPercentage to compare the actual HorizontalPodAutoscalerStatus's currentCPUUtilizationPercentage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerStatus's currentCPUUtilizationPercentage is not equal to the given one.
   */
  public S hasCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
    // check that actual HorizontalPodAutoscalerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting currentCPUUtilizationPercentage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCurrentCPUUtilizationPercentage = actual.getCurrentCPUUtilizationPercentage();
    if (!Objects.areEqual(actualCurrentCPUUtilizationPercentage, currentCPUUtilizationPercentage)) {
      failWithMessage(assertjErrorMessage, actual, currentCPUUtilizationPercentage, actualCurrentCPUUtilizationPercentage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerStatus's currentReplicas is equal to the given one.
   * @param currentReplicas the given currentReplicas to compare the actual HorizontalPodAutoscalerStatus's currentReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerStatus's currentReplicas is not equal to the given one.
   */
  public S hasCurrentReplicas(Integer currentReplicas) {
    // check that actual HorizontalPodAutoscalerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting currentReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCurrentReplicas = actual.getCurrentReplicas();
    if (!Objects.areEqual(actualCurrentReplicas, currentReplicas)) {
      failWithMessage(assertjErrorMessage, actual, currentReplicas, actualCurrentReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerStatus's desiredReplicas is equal to the given one.
   * @param desiredReplicas the given desiredReplicas to compare the actual HorizontalPodAutoscalerStatus's desiredReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerStatus's desiredReplicas is not equal to the given one.
   */
  public S hasDesiredReplicas(Integer desiredReplicas) {
    // check that actual HorizontalPodAutoscalerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting desiredReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDesiredReplicas = actual.getDesiredReplicas();
    if (!Objects.areEqual(actualDesiredReplicas, desiredReplicas)) {
      failWithMessage(assertjErrorMessage, actual, desiredReplicas, actualDesiredReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerStatus's lastScaleTime is equal to the given one.
   * @param lastScaleTime the given lastScaleTime to compare the actual HorizontalPodAutoscalerStatus's lastScaleTime to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerStatus's lastScaleTime is not equal to the given one.
   */
  public S hasLastScaleTime(String lastScaleTime) {
    // check that actual HorizontalPodAutoscalerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastScaleTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastScaleTime = actual.getLastScaleTime();
    if (!Objects.areEqual(actualLastScaleTime, lastScaleTime)) {
      failWithMessage(assertjErrorMessage, actual, lastScaleTime, actualLastScaleTime);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerStatus's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual HorizontalPodAutoscalerStatus's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerStatus's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual HorizontalPodAutoscalerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
