package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodSelector} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSelectorAssert<S extends AbstractPodSelectorAssert<S, A>, A extends PodSelector> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSelectorAssert}</code> to make assertions on actual PodSelector.
   * @param actual the PodSelector we want to make assertions on.
   */
  protected AbstractPodSelectorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodSelector's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodSelector's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSelector's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodSelector we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelector's matchExpressions contains the given PodSelectorRequirement elements.
   * @param matchExpressions the given elements that should be contained in actual PodSelector's matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelector's matchExpressions does not contain all given PodSelectorRequirement elements.
   */
  public S hasMatchExpressions(PodSelectorRequirement... matchExpressions) {
    // check that actual PodSelector we want to make assertions on is not null.
    isNotNull();

    // check that given PodSelectorRequirement varargs is not null.
    if (matchExpressions == null) failWithMessage("Expecting matchExpressions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getMatchExpressions(), matchExpressions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelector's matchExpressions contains <b>only<b> the given PodSelectorRequirement elements and nothing else in whatever order.
   * @param matchExpressions the given elements that should be contained in actual PodSelector's matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelector's matchExpressions does not contain all given PodSelectorRequirement elements.
   */
  public S hasOnlyMatchExpressions(PodSelectorRequirement... matchExpressions) {
    // check that actual PodSelector we want to make assertions on is not null.
    isNotNull();

    // check that given PodSelectorRequirement varargs is not null.
    if (matchExpressions == null) failWithMessage("Expecting matchExpressions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getMatchExpressions(), matchExpressions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelector's matchExpressions does not contain the given PodSelectorRequirement elements.
   *
   * @param matchExpressions the given elements that should not be in actual PodSelector's matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelector's matchExpressions contains any given PodSelectorRequirement elements.
   */
  public S doesNotHaveMatchExpressions(PodSelectorRequirement... matchExpressions) {
    // check that actual PodSelector we want to make assertions on is not null.
    isNotNull();

    // check that given PodSelectorRequirement varargs is not null.
    if (matchExpressions == null) failWithMessage("Expecting matchExpressions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getMatchExpressions(), matchExpressions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelector has no matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelector's matchExpressions is not empty.
   */
  public S hasNoMatchExpressions() {
    // check that actual PodSelector we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have matchExpressions but had :\n  <%s>";
    
    // check
    if (actual.getMatchExpressions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getMatchExpressions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PodSelector's matchLabels is equal to the given one.
   * @param matchLabels the given matchLabels to compare the actual PodSelector's matchLabels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSelector's matchLabels is not equal to the given one.
   */
  public S hasMatchLabels(java.util.Map matchLabels) {
    // check that actual PodSelector we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting matchLabels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualMatchLabels = actual.getMatchLabels();
    if (!Objects.areEqual(actualMatchLabels, matchLabels)) {
      failWithMessage(assertjErrorMessage, actual, matchLabels, actualMatchLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
