package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BinaryBuildSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBinaryBuildSourceAssert<S extends AbstractBinaryBuildSourceAssert<S, A>, A extends BinaryBuildSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBinaryBuildSourceAssert}</code> to make assertions on actual BinaryBuildSource.
   * @param actual the BinaryBuildSource we want to make assertions on.
   */
  protected AbstractBinaryBuildSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BinaryBuildSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BinaryBuildSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BinaryBuildSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BinaryBuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BinaryBuildSource's asFile is equal to the given one.
   * @param asFile the given asFile to compare the actual BinaryBuildSource's asFile to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BinaryBuildSource's asFile is not equal to the given one.
   */
  public S hasAsFile(String asFile) {
    // check that actual BinaryBuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting asFile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualAsFile = actual.getAsFile();
    if (!Objects.areEqual(actualAsFile, asFile)) {
      failWithMessage(assertjErrorMessage, actual, asFile, actualAsFile);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
