package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildSpecAssert<S extends AbstractBuildSpecAssert<S, A>, A extends BuildSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildSpecAssert}</code> to make assertions on actual BuildSpec.
   * @param actual the BuildSpec we want to make assertions on.
   */
  protected AbstractBuildSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpec's completionDeadlineSeconds is equal to the given one.
   * @param completionDeadlineSeconds the given completionDeadlineSeconds to compare the actual BuildSpec's completionDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's completionDeadlineSeconds is not equal to the given one.
   */
  public S hasCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting completionDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualCompletionDeadlineSeconds = actual.getCompletionDeadlineSeconds();
    if (!Objects.areEqual(actualCompletionDeadlineSeconds, completionDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, completionDeadlineSeconds, actualCompletionDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpec's output is equal to the given one.
   * @param output the given output to compare the actual BuildSpec's output to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's output is not equal to the given one.
   */
  public S hasOutput(BuildOutput output) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting output of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildOutput actualOutput = actual.getOutput();
    if (!Objects.areEqual(actualOutput, output)) {
      failWithMessage(assertjErrorMessage, actual, output, actualOutput);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpec's resources is equal to the given one.
   * @param resources the given resources to compare the actual BuildSpec's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's resources is not equal to the given one.
   */
  public S hasResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ResourceRequirements actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpec's revision is equal to the given one.
   * @param revision the given revision to compare the actual BuildSpec's revision to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's revision is not equal to the given one.
   */
  public S hasRevision(SourceRevision revision) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revision of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceRevision actualRevision = actual.getRevision();
    if (!Objects.areEqual(actualRevision, revision)) {
      failWithMessage(assertjErrorMessage, actual, revision, actualRevision);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpec's serviceAccount is equal to the given one.
   * @param serviceAccount the given serviceAccount to compare the actual BuildSpec's serviceAccount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's serviceAccount is not equal to the given one.
   */
  public S hasServiceAccount(String serviceAccount) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting serviceAccount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServiceAccount = actual.getServiceAccount();
    if (!Objects.areEqual(actualServiceAccount, serviceAccount)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccount, actualServiceAccount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpec's source is equal to the given one.
   * @param source the given source to compare the actual BuildSpec's source to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's source is not equal to the given one.
   */
  public S hasSource(BuildSource source) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting source of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildSource actualSource = actual.getSource();
    if (!Objects.areEqual(actualSource, source)) {
      failWithMessage(assertjErrorMessage, actual, source, actualSource);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpec's strategy is equal to the given one.
   * @param strategy the given strategy to compare the actual BuildSpec's strategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpec's strategy is not equal to the given one.
   */
  public S hasStrategy(BuildStrategy strategy) {
    // check that actual BuildSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting strategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildStrategy actualStrategy = actual.getStrategy();
    if (!Objects.areEqual(actualStrategy, strategy)) {
      failWithMessage(assertjErrorMessage, actual, strategy, actualStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
