package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildStrategyAssert<S extends AbstractBuildStrategyAssert<S, A>, A extends BuildStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildStrategyAssert}</code> to make assertions on actual BuildStrategy.
   * @param actual the BuildStrategy we want to make assertions on.
   */
  protected AbstractBuildStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildStrategy's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildStrategy's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategy's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategy's customStrategy is equal to the given one.
   * @param customStrategy the given customStrategy to compare the actual BuildStrategy's customStrategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategy's customStrategy is not equal to the given one.
   */
  public S hasCustomStrategy(CustomBuildStrategy customStrategy) {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting customStrategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CustomBuildStrategy actualCustomStrategy = actual.getCustomStrategy();
    if (!Objects.areEqual(actualCustomStrategy, customStrategy)) {
      failWithMessage(assertjErrorMessage, actual, customStrategy, actualCustomStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategy's dockerStrategy is equal to the given one.
   * @param dockerStrategy the given dockerStrategy to compare the actual BuildStrategy's dockerStrategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategy's dockerStrategy is not equal to the given one.
   */
  public S hasDockerStrategy(DockerBuildStrategy dockerStrategy) {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerStrategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DockerBuildStrategy actualDockerStrategy = actual.getDockerStrategy();
    if (!Objects.areEqual(actualDockerStrategy, dockerStrategy)) {
      failWithMessage(assertjErrorMessage, actual, dockerStrategy, actualDockerStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategy's sourceStrategy is equal to the given one.
   * @param sourceStrategy the given sourceStrategy to compare the actual BuildStrategy's sourceStrategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategy's sourceStrategy is not equal to the given one.
   */
  public S hasSourceStrategy(SourceBuildStrategy sourceStrategy) {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting sourceStrategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceBuildStrategy actualSourceStrategy = actual.getSourceStrategy();
    if (!Objects.areEqual(actualSourceStrategy, sourceStrategy)) {
      failWithMessage(assertjErrorMessage, actual, sourceStrategy, actualSourceStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategy's type is equal to the given one.
   * @param type the given type to compare the actual BuildStrategy's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategy's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
