package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ClusterPolicyBindingFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterPolicyBindingFluentImplAssert<S extends AbstractClusterPolicyBindingFluentImplAssert<S, A>, A extends ClusterPolicyBindingFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterPolicyBindingFluentImplAssert}</code> to make assertions on actual ClusterPolicyBindingFluentImpl.
   * @param actual the ClusterPolicyBindingFluentImpl we want to make assertions on.
   */
  protected AbstractClusterPolicyBindingFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ClusterPolicyBindingFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ClusterPolicyBindingFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ClusterPolicyBinding.ApiVersion apiVersion) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ClusterPolicyBinding.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ClusterPolicyBindingFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's lastModified is equal to the given one.
   * @param lastModified the given lastModified to compare the actual ClusterPolicyBindingFluentImpl's lastModified to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingFluentImpl's lastModified is not equal to the given one.
   */
  public S hasLastModified(String lastModified) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastModified of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastModified = actual.getLastModified();
    if (!Objects.areEqual(actualLastModified, lastModified)) {
      failWithMessage(assertjErrorMessage, actual, lastModified, actualLastModified);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ClusterPolicyBindingFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's policyRef is equal to the given one.
   * @param policyRef the given policyRef to compare the actual ClusterPolicyBindingFluentImpl's policyRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingFluentImpl's policyRef is not equal to the given one.
   */
  public S hasPolicyRef(io.fabric8.kubernetes.api.model.ObjectReference policyRef) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting policyRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualPolicyRef = actual.getPolicyRef();
    if (!Objects.areEqual(actualPolicyRef, policyRef)) {
      failWithMessage(assertjErrorMessage, actual, policyRef, actualPolicyRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's roleBindings contains the given NamedClusterRoleBinding elements.
   * @param roleBindings the given elements that should be contained in actual ClusterPolicyBindingFluentImpl's roleBindings.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingFluentImpl's roleBindings does not contain all given NamedClusterRoleBinding elements.
   */
  public S hasRoleBindings(NamedClusterRoleBinding... roleBindings) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedClusterRoleBinding varargs is not null.
    if (roleBindings == null) failWithMessage("Expecting roleBindings parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRoleBindings(), roleBindings);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's roleBindings contains <b>only<b> the given NamedClusterRoleBinding elements and nothing else in whatever order.
   * @param roleBindings the given elements that should be contained in actual ClusterPolicyBindingFluentImpl's roleBindings.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingFluentImpl's roleBindings does not contain all given NamedClusterRoleBinding elements.
   */
  public S hasOnlyRoleBindings(NamedClusterRoleBinding... roleBindings) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedClusterRoleBinding varargs is not null.
    if (roleBindings == null) failWithMessage("Expecting roleBindings parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getRoleBindings(), roleBindings);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl's roleBindings does not contain the given NamedClusterRoleBinding elements.
   *
   * @param roleBindings the given elements that should not be in actual ClusterPolicyBindingFluentImpl's roleBindings.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingFluentImpl's roleBindings contains any given NamedClusterRoleBinding elements.
   */
  public S doesNotHaveRoleBindings(NamedClusterRoleBinding... roleBindings) {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedClusterRoleBinding varargs is not null.
    if (roleBindings == null) failWithMessage("Expecting roleBindings parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getRoleBindings(), roleBindings);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingFluentImpl has no roleBindings.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingFluentImpl's roleBindings is not empty.
   */
  public S hasNoRoleBindings() {
    // check that actual ClusterPolicyBindingFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have roleBindings but had :\n  <%s>";
    
    // check
    if (actual.getRoleBindings().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRoleBindings());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
