package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ClusterPolicyBindingListFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterPolicyBindingListFluentImplAssert<S extends AbstractClusterPolicyBindingListFluentImplAssert<S, A>, A extends ClusterPolicyBindingListFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterPolicyBindingListFluentImplAssert}</code> to make assertions on actual ClusterPolicyBindingListFluentImpl.
   * @param actual the ClusterPolicyBindingListFluentImpl we want to make assertions on.
   */
  protected AbstractClusterPolicyBindingListFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ClusterPolicyBindingListFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingListFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ClusterPolicyBindingListFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingListFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ClusterPolicyBindingList.ApiVersion apiVersion) {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ClusterPolicyBindingList.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl's items contains the given ClusterPolicyBinding elements.
   * @param items the given elements that should be contained in actual ClusterPolicyBindingListFluentImpl's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingListFluentImpl's items does not contain all given ClusterPolicyBinding elements.
   */
  public S hasItems(ClusterPolicyBinding... items) {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ClusterPolicyBinding varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl's items contains <b>only<b> the given ClusterPolicyBinding elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual ClusterPolicyBindingListFluentImpl's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingListFluentImpl's items does not contain all given ClusterPolicyBinding elements.
   */
  public S hasOnlyItems(ClusterPolicyBinding... items) {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ClusterPolicyBinding varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl's items does not contain the given ClusterPolicyBinding elements.
   *
   * @param items the given elements that should not be in actual ClusterPolicyBindingListFluentImpl's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingListFluentImpl's items contains any given ClusterPolicyBinding elements.
   */
  public S doesNotHaveItems(ClusterPolicyBinding... items) {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ClusterPolicyBinding varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterPolicyBindingListFluentImpl's items is not empty.
   */
  public S hasNoItems() {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ClusterPolicyBindingListFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingListFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterPolicyBindingListFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ClusterPolicyBindingListFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterPolicyBindingListFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
    // check that actual ClusterPolicyBindingListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ListMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
