package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedClusterRoleFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedClusterRoleFluentAssert<S extends AbstractNamedClusterRoleFluentAssert<S, A>, A extends NamedClusterRoleFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedClusterRoleFluentAssert}</code> to make assertions on actual NamedClusterRoleFluent.
   * @param actual the NamedClusterRoleFluent we want to make assertions on.
   */
  protected AbstractNamedClusterRoleFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedClusterRoleFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedClusterRoleFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterRoleFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedClusterRoleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterRoleFluent's name is equal to the given one.
   * @param name the given name to compare the actual NamedClusterRoleFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterRoleFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedClusterRoleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterRoleFluent's role is equal to the given one.
   * @param role the given role to compare the actual NamedClusterRoleFluent's role to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterRoleFluent's role is not equal to the given one.
   */
  public S hasRole(ClusterRole role) {
    // check that actual NamedClusterRoleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting role of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ClusterRole actualRole = actual.getRole();
    if (!Objects.areEqual(actualRole, role)) {
      failWithMessage(assertjErrorMessage, actual, role, actualRole);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
