package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedRoleFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedRoleFluentAssert<S extends AbstractNamedRoleFluentAssert<S, A>, A extends NamedRoleFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedRoleFluentAssert}</code> to make assertions on actual NamedRoleFluent.
   * @param actual the NamedRoleFluent we want to make assertions on.
   */
  protected AbstractNamedRoleFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedRoleFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedRoleFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedRoleFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedRoleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedRoleFluent's name is equal to the given one.
   * @param name the given name to compare the actual NamedRoleFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedRoleFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedRoleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedRoleFluent's role is equal to the given one.
   * @param role the given role to compare the actual NamedRoleFluent's role to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedRoleFluent's role is not equal to the given one.
   */
  public S hasRole(Role role) {
    // check that actual NamedRoleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting role of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Role actualRole = actual.getRole();
    if (!Objects.areEqual(actualRole, role)) {
      failWithMessage(assertjErrorMessage, actual, role, actualRole);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
