package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PolicyRule} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPolicyRuleAssert<S extends AbstractPolicyRuleAssert<S, A>, A extends PolicyRule> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPolicyRuleAssert}</code> to make assertions on actual PolicyRule.
   * @param actual the PolicyRule we want to make assertions on.
   */
  protected AbstractPolicyRuleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PolicyRule's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PolicyRule's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyRule's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's apiGroups contains the given String elements.
   * @param apiGroups the given elements that should be contained in actual PolicyRule's apiGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's apiGroups does not contain all given String elements.
   */
  public S hasApiGroups(String... apiGroups) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (apiGroups == null) failWithMessage("Expecting apiGroups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getApiGroups(), apiGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's apiGroups contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param apiGroups the given elements that should be contained in actual PolicyRule's apiGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's apiGroups does not contain all given String elements.
   */
  public S hasOnlyApiGroups(String... apiGroups) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (apiGroups == null) failWithMessage("Expecting apiGroups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getApiGroups(), apiGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's apiGroups does not contain the given String elements.
   *
   * @param apiGroups the given elements that should not be in actual PolicyRule's apiGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's apiGroups contains any given String elements.
   */
  public S doesNotHaveApiGroups(String... apiGroups) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (apiGroups == null) failWithMessage("Expecting apiGroups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getApiGroups(), apiGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule has no apiGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's apiGroups is not empty.
   */
  public S hasNoApiGroups() {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have apiGroups but had :\n  <%s>";
    
    // check
    if (actual.getApiGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getApiGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PolicyRule's attributeRestrictions is equal to the given one.
   * @param attributeRestrictions the given attributeRestrictions to compare the actual PolicyRule's attributeRestrictions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyRule's attributeRestrictions is not equal to the given one.
   */
  public S hasAttributeRestrictions(io.fabric8.kubernetes.api.model.HasMetadata attributeRestrictions) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting attributeRestrictions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.HasMetadata actualAttributeRestrictions = actual.getAttributeRestrictions();
    if (!Objects.areEqual(actualAttributeRestrictions, attributeRestrictions)) {
      failWithMessage(assertjErrorMessage, actual, attributeRestrictions, actualAttributeRestrictions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's nonResourceURLs contains the given String elements.
   * @param nonResourceURLs the given elements that should be contained in actual PolicyRule's nonResourceURLs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's nonResourceURLs does not contain all given String elements.
   */
  public S hasNonResourceURLs(String... nonResourceURLs) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (nonResourceURLs == null) failWithMessage("Expecting nonResourceURLs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getNonResourceURLs(), nonResourceURLs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's nonResourceURLs contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param nonResourceURLs the given elements that should be contained in actual PolicyRule's nonResourceURLs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's nonResourceURLs does not contain all given String elements.
   */
  public S hasOnlyNonResourceURLs(String... nonResourceURLs) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (nonResourceURLs == null) failWithMessage("Expecting nonResourceURLs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getNonResourceURLs(), nonResourceURLs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's nonResourceURLs does not contain the given String elements.
   *
   * @param nonResourceURLs the given elements that should not be in actual PolicyRule's nonResourceURLs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's nonResourceURLs contains any given String elements.
   */
  public S doesNotHaveNonResourceURLs(String... nonResourceURLs) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (nonResourceURLs == null) failWithMessage("Expecting nonResourceURLs parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getNonResourceURLs(), nonResourceURLs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule has no nonResourceURLs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's nonResourceURLs is not empty.
   */
  public S hasNoNonResourceURLs() {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have nonResourceURLs but had :\n  <%s>";
    
    // check
    if (actual.getNonResourceURLs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getNonResourceURLs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PolicyRule's resourceNames contains the given String elements.
   * @param resourceNames the given elements that should be contained in actual PolicyRule's resourceNames.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resourceNames does not contain all given String elements.
   */
  public S hasResourceNames(String... resourceNames) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resourceNames == null) failWithMessage("Expecting resourceNames parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getResourceNames(), resourceNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's resourceNames contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param resourceNames the given elements that should be contained in actual PolicyRule's resourceNames.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resourceNames does not contain all given String elements.
   */
  public S hasOnlyResourceNames(String... resourceNames) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resourceNames == null) failWithMessage("Expecting resourceNames parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getResourceNames(), resourceNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's resourceNames does not contain the given String elements.
   *
   * @param resourceNames the given elements that should not be in actual PolicyRule's resourceNames.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resourceNames contains any given String elements.
   */
  public S doesNotHaveResourceNames(String... resourceNames) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resourceNames == null) failWithMessage("Expecting resourceNames parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getResourceNames(), resourceNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule has no resourceNames.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resourceNames is not empty.
   */
  public S hasNoResourceNames() {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resourceNames but had :\n  <%s>";
    
    // check
    if (actual.getResourceNames().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getResourceNames());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PolicyRule's resources contains the given String elements.
   * @param resources the given elements that should be contained in actual PolicyRule's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resources does not contain all given String elements.
   */
  public S hasResources(String... resources) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resources == null) failWithMessage("Expecting resources parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getResources(), resources);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's resources contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param resources the given elements that should be contained in actual PolicyRule's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resources does not contain all given String elements.
   */
  public S hasOnlyResources(String... resources) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resources == null) failWithMessage("Expecting resources parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getResources(), resources);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's resources does not contain the given String elements.
   *
   * @param resources the given elements that should not be in actual PolicyRule's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resources contains any given String elements.
   */
  public S doesNotHaveResources(String... resources) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resources == null) failWithMessage("Expecting resources parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getResources(), resources);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule has no resources.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's resources is not empty.
   */
  public S hasNoResources() {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resources but had :\n  <%s>";
    
    // check
    if (actual.getResources().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getResources());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PolicyRule's verbs contains the given String elements.
   * @param verbs the given elements that should be contained in actual PolicyRule's verbs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's verbs does not contain all given String elements.
   */
  public S hasVerbs(String... verbs) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (verbs == null) failWithMessage("Expecting verbs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVerbs(), verbs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's verbs contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param verbs the given elements that should be contained in actual PolicyRule's verbs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's verbs does not contain all given String elements.
   */
  public S hasOnlyVerbs(String... verbs) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (verbs == null) failWithMessage("Expecting verbs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getVerbs(), verbs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule's verbs does not contain the given String elements.
   *
   * @param verbs the given elements that should not be in actual PolicyRule's verbs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's verbs contains any given String elements.
   */
  public S doesNotHaveVerbs(String... verbs) {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (verbs == null) failWithMessage("Expecting verbs parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getVerbs(), verbs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRule has no verbs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRule's verbs is not empty.
   */
  public S hasNoVerbs() {
    // check that actual PolicyRule we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have verbs but had :\n  <%s>";
    
    // check
    if (actual.getVerbs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVerbs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
