package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecretSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretSpecAssert<S extends AbstractSecretSpecAssert<S, A>, A extends SecretSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretSpecAssert}</code> to make assertions on actual SecretSpec.
   * @param actual the SecretSpec we want to make assertions on.
   */
  protected AbstractSecretSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecretSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecretSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecretSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecretSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecretSpec's mountPath is equal to the given one.
   * @param mountPath the given mountPath to compare the actual SecretSpec's mountPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecretSpec's mountPath is not equal to the given one.
   */
  public S hasMountPath(String mountPath) {
    // check that actual SecretSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting mountPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMountPath = actual.getMountPath();
    if (!Objects.areEqual(actualMountPath, mountPath)) {
      failWithMessage(assertjErrorMessage, actual, mountPath, actualMountPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecretSpec's secretSource is equal to the given one.
   * @param secretSource the given secretSource to compare the actual SecretSpec's secretSource to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecretSpec's secretSource is not equal to the given one.
   */
  public S hasSecretSource(io.fabric8.kubernetes.api.model.LocalObjectReference secretSource) {
    // check that actual SecretSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secretSource of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualSecretSource = actual.getSecretSource();
    if (!Objects.areEqual(actualSecretSource, secretSource)) {
      failWithMessage(assertjErrorMessage, actual, secretSource, actualSecretSource);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
