package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link AWSElasticBlockStoreVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAWSElasticBlockStoreVolumeSourceAssert<S extends AbstractAWSElasticBlockStoreVolumeSourceAssert<S, A>, A extends AWSElasticBlockStoreVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAWSElasticBlockStoreVolumeSourceAssert}</code> to make assertions on actual AWSElasticBlockStoreVolumeSource.
   * @param actual the AWSElasticBlockStoreVolumeSource we want to make assertions on.
   */
  protected AbstractAWSElasticBlockStoreVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual AWSElasticBlockStoreVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual AWSElasticBlockStoreVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AWSElasticBlockStoreVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual AWSElasticBlockStoreVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AWSElasticBlockStoreVolumeSource's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual AWSElasticBlockStoreVolumeSource's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AWSElasticBlockStoreVolumeSource's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual AWSElasticBlockStoreVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AWSElasticBlockStoreVolumeSource's partition is equal to the given one.
   * @param partition the given partition to compare the actual AWSElasticBlockStoreVolumeSource's partition to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AWSElasticBlockStoreVolumeSource's partition is not equal to the given one.
   */
  public S hasPartition(Integer partition) {
    // check that actual AWSElasticBlockStoreVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting partition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPartition = actual.getPartition();
    if (!Objects.areEqual(actualPartition, partition)) {
      failWithMessage(assertjErrorMessage, actual, partition, actualPartition);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AWSElasticBlockStoreVolumeSource's readOnly is equal to the given one.
   * @param readOnly the given readOnly to compare the actual AWSElasticBlockStoreVolumeSource's readOnly to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AWSElasticBlockStoreVolumeSource's readOnly is not equal to the given one.
   */
  public S hasReadOnly(Boolean readOnly) {
    // check that actual AWSElasticBlockStoreVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readOnly of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReadOnly = actual.getReadOnly();
    if (!Objects.areEqual(actualReadOnly, readOnly)) {
      failWithMessage(assertjErrorMessage, actual, readOnly, actualReadOnly);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AWSElasticBlockStoreVolumeSource's volumeID is equal to the given one.
   * @param volumeID the given volumeID to compare the actual AWSElasticBlockStoreVolumeSource's volumeID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AWSElasticBlockStoreVolumeSource's volumeID is not equal to the given one.
   */
  public S hasVolumeID(String volumeID) {
    // check that actual AWSElasticBlockStoreVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting volumeID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualVolumeID = actual.getVolumeID();
    if (!Objects.areEqual(actualVolumeID, volumeID)) {
      failWithMessage(assertjErrorMessage, actual, volumeID, actualVolumeID);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
