package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CinderVolumeSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCinderVolumeSourceFluentAssert<S extends AbstractCinderVolumeSourceFluentAssert<S, A>, A extends CinderVolumeSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCinderVolumeSourceFluentAssert}</code> to make assertions on actual CinderVolumeSourceFluent.
   * @param actual the CinderVolumeSourceFluent we want to make assertions on.
   */
  protected AbstractCinderVolumeSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CinderVolumeSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CinderVolumeSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CinderVolumeSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CinderVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CinderVolumeSourceFluent's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual CinderVolumeSourceFluent's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CinderVolumeSourceFluent's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual CinderVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CinderVolumeSourceFluent's volumeID is equal to the given one.
   * @param volumeID the given volumeID to compare the actual CinderVolumeSourceFluent's volumeID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CinderVolumeSourceFluent's volumeID is not equal to the given one.
   */
  public S hasVolumeID(String volumeID) {
    // check that actual CinderVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting volumeID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualVolumeID = actual.getVolumeID();
    if (!Objects.areEqual(actualVolumeID, volumeID)) {
      failWithMessage(assertjErrorMessage, actual, volumeID, actualVolumeID);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
