package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ComponentConditionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractComponentConditionFluentAssert<S extends AbstractComponentConditionFluentAssert<S, A>, A extends ComponentConditionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractComponentConditionFluentAssert}</code> to make assertions on actual ComponentConditionFluent.
   * @param actual the ComponentConditionFluent we want to make assertions on.
   */
  protected AbstractComponentConditionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ComponentConditionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ComponentConditionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentConditionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ComponentConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentConditionFluent's error is equal to the given one.
   * @param error the given error to compare the actual ComponentConditionFluent's error to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentConditionFluent's error is not equal to the given one.
   */
  public S hasError(String error) {
    // check that actual ComponentConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting error of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualError = actual.getError();
    if (!Objects.areEqual(actualError, error)) {
      failWithMessage(assertjErrorMessage, actual, error, actualError);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentConditionFluent's message is equal to the given one.
   * @param message the given message to compare the actual ComponentConditionFluent's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentConditionFluent's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual ComponentConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentConditionFluent's status is equal to the given one.
   * @param status the given status to compare the actual ComponentConditionFluent's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentConditionFluent's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual ComponentConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentConditionFluent's type is equal to the given one.
   * @param type the given type to compare the actual ComponentConditionFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentConditionFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual ComponentConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
