package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerStateFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStateFluentImplAssert<S extends AbstractContainerStateFluentImplAssert<S, A>, A extends ContainerStateFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStateFluentImplAssert}</code> to make assertions on actual ContainerStateFluentImpl.
   * @param actual the ContainerStateFluentImpl we want to make assertions on.
   */
  protected AbstractContainerStateFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerStateFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerStateFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerStateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateFluentImpl's running is equal to the given one.
   * @param running the given running to compare the actual ContainerStateFluentImpl's running to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateFluentImpl's running is not equal to the given one.
   */
  public S hasRunning(ContainerStateRunning running) {
    // check that actual ContainerStateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting running of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerStateRunning actualRunning = actual.getRunning();
    if (!Objects.areEqual(actualRunning, running)) {
      failWithMessage(assertjErrorMessage, actual, running, actualRunning);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateFluentImpl's terminated is equal to the given one.
   * @param terminated the given terminated to compare the actual ContainerStateFluentImpl's terminated to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateFluentImpl's terminated is not equal to the given one.
   */
  public S hasTerminated(ContainerStateTerminated terminated) {
    // check that actual ContainerStateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting terminated of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerStateTerminated actualTerminated = actual.getTerminated();
    if (!Objects.areEqual(actualTerminated, terminated)) {
      failWithMessage(assertjErrorMessage, actual, terminated, actualTerminated);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateFluentImpl's waiting is equal to the given one.
   * @param waiting the given waiting to compare the actual ContainerStateFluentImpl's waiting to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateFluentImpl's waiting is not equal to the given one.
   */
  public S hasWaiting(ContainerStateWaiting waiting) {
    // check that actual ContainerStateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting waiting of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerStateWaiting actualWaiting = actual.getWaiting();
    if (!Objects.areEqual(actualWaiting, waiting)) {
      failWithMessage(assertjErrorMessage, actual, waiting, actualWaiting);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
