package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContextFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContextFluentImplAssert<S extends AbstractContextFluentImplAssert<S, A>, A extends ContextFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContextFluentImplAssert}</code> to make assertions on actual ContextFluentImpl.
   * @param actual the ContextFluentImpl we want to make assertions on.
   */
  protected AbstractContextFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContextFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContextFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluentImpl's cluster is equal to the given one.
   * @param cluster the given cluster to compare the actual ContextFluentImpl's cluster to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluentImpl's cluster is not equal to the given one.
   */
  public S hasCluster(String cluster) {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cluster of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCluster = actual.getCluster();
    if (!Objects.areEqual(actualCluster, cluster)) {
      failWithMessage(assertjErrorMessage, actual, cluster, actualCluster);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluentImpl's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual ContextFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ContextFluentImpl's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluentImpl's extensions contains <b>only<b> the given NamedExtension elements and nothing else in whatever order.
   * @param extensions the given elements that should be contained in actual ContextFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ContextFluentImpl's extensions does not contain all given NamedExtension elements.
   */
  public S hasOnlyExtensions(NamedExtension... extensions) {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluentImpl's extensions does not contain the given NamedExtension elements.
   *
   * @param extensions the given elements that should not be in actual ContextFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ContextFluentImpl's extensions contains any given NamedExtension elements.
   */
  public S doesNotHaveExtensions(NamedExtension... extensions) {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluentImpl has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ContextFluentImpl's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContextFluentImpl's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual ContextFluentImpl's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluentImpl's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluentImpl's user is equal to the given one.
   * @param user the given user to compare the actual ContextFluentImpl's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluentImpl's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual ContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
