package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link FCVolumeSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractFCVolumeSourceFluentImplAssert<S extends AbstractFCVolumeSourceFluentImplAssert<S, A>, A extends FCVolumeSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractFCVolumeSourceFluentImplAssert}</code> to make assertions on actual FCVolumeSourceFluentImpl.
   * @param actual the FCVolumeSourceFluentImpl we want to make assertions on.
   */
  protected AbstractFCVolumeSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual FCVolumeSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual FCVolumeSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FCVolumeSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual FCVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FCVolumeSourceFluentImpl's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual FCVolumeSourceFluentImpl's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FCVolumeSourceFluentImpl's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual FCVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FCVolumeSourceFluentImpl's lun is equal to the given one.
   * @param lun the given lun to compare the actual FCVolumeSourceFluentImpl's lun to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FCVolumeSourceFluentImpl's lun is not equal to the given one.
   */
  public S hasLun(Integer lun) {
    // check that actual FCVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lun of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLun = actual.getLun();
    if (!Objects.areEqual(actualLun, lun)) {
      failWithMessage(assertjErrorMessage, actual, lun, actualLun);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FCVolumeSourceFluentImpl's targetWWNs contains the given String elements.
   * @param targetWWNs the given elements that should be contained in actual FCVolumeSourceFluentImpl's targetWWNs.
   * @return this assertion object.
   * @throws AssertionError if the actual FCVolumeSourceFluentImpl's targetWWNs does not contain all given String elements.
   */
  public S hasTargetWWNs(String... targetWWNs) {
    // check that actual FCVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (targetWWNs == null) failWithMessage("Expecting targetWWNs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTargetWWNs(), targetWWNs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FCVolumeSourceFluentImpl's targetWWNs contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param targetWWNs the given elements that should be contained in actual FCVolumeSourceFluentImpl's targetWWNs.
   * @return this assertion object.
   * @throws AssertionError if the actual FCVolumeSourceFluentImpl's targetWWNs does not contain all given String elements.
   */
  public S hasOnlyTargetWWNs(String... targetWWNs) {
    // check that actual FCVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (targetWWNs == null) failWithMessage("Expecting targetWWNs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getTargetWWNs(), targetWWNs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FCVolumeSourceFluentImpl's targetWWNs does not contain the given String elements.
   *
   * @param targetWWNs the given elements that should not be in actual FCVolumeSourceFluentImpl's targetWWNs.
   * @return this assertion object.
   * @throws AssertionError if the actual FCVolumeSourceFluentImpl's targetWWNs contains any given String elements.
   */
  public S doesNotHaveTargetWWNs(String... targetWWNs) {
    // check that actual FCVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (targetWWNs == null) failWithMessage("Expecting targetWWNs parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getTargetWWNs(), targetWWNs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FCVolumeSourceFluentImpl has no targetWWNs.
   * @return this assertion object.
   * @throws AssertionError if the actual FCVolumeSourceFluentImpl's targetWWNs is not empty.
   */
  public S hasNoTargetWWNs() {
    // check that actual FCVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have targetWWNs but had :\n  <%s>";
    
    // check
    if (actual.getTargetWWNs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTargetWWNs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
