package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MetadataVolumeSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMetadataVolumeSourceFluentAssert<S extends AbstractMetadataVolumeSourceFluentAssert<S, A>, A extends MetadataVolumeSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMetadataVolumeSourceFluentAssert}</code> to make assertions on actual MetadataVolumeSourceFluent.
   * @param actual the MetadataVolumeSourceFluent we want to make assertions on.
   */
  protected AbstractMetadataVolumeSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual MetadataVolumeSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MetadataVolumeSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual MetadataVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluent's items contains the given MetadataFile elements.
   * @param items the given elements that should be contained in actual MetadataVolumeSourceFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual MetadataVolumeSourceFluent's items does not contain all given MetadataFile elements.
   */
  public S hasItems(MetadataFile... items) {
    // check that actual MetadataVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given MetadataFile varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluent's items contains <b>only<b> the given MetadataFile elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual MetadataVolumeSourceFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual MetadataVolumeSourceFluent's items does not contain all given MetadataFile elements.
   */
  public S hasOnlyItems(MetadataFile... items) {
    // check that actual MetadataVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given MetadataFile varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluent's items does not contain the given MetadataFile elements.
   *
   * @param items the given elements that should not be in actual MetadataVolumeSourceFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual MetadataVolumeSourceFluent's items contains any given MetadataFile elements.
   */
  public S doesNotHaveItems(MetadataFile... items) {
    // check that actual MetadataVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given MetadataFile varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluent has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual MetadataVolumeSourceFluent's items is not empty.
   */
  public S hasNoItems() {
    // check that actual MetadataVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
