package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NFSVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNFSVolumeSourceAssert<S extends AbstractNFSVolumeSourceAssert<S, A>, A extends NFSVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNFSVolumeSourceAssert}</code> to make assertions on actual NFSVolumeSource.
   * @param actual the NFSVolumeSource we want to make assertions on.
   */
  protected AbstractNFSVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NFSVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NFSVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NFSVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NFSVolumeSource's path is equal to the given one.
   * @param path the given path to compare the actual NFSVolumeSource's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NFSVolumeSource's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual NFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NFSVolumeSource's readOnly is equal to the given one.
   * @param readOnly the given readOnly to compare the actual NFSVolumeSource's readOnly to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NFSVolumeSource's readOnly is not equal to the given one.
   */
  public S hasReadOnly(Boolean readOnly) {
    // check that actual NFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readOnly of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReadOnly = actual.getReadOnly();
    if (!Objects.areEqual(actualReadOnly, readOnly)) {
      failWithMessage(assertjErrorMessage, actual, readOnly, actualReadOnly);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NFSVolumeSource's server is equal to the given one.
   * @param server the given server to compare the actual NFSVolumeSource's server to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NFSVolumeSource's server is not equal to the given one.
   */
  public S hasServer(String server) {
    // check that actual NFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting server of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServer = actual.getServer();
    if (!Objects.areEqual(actualServer, server)) {
      failWithMessage(assertjErrorMessage, actual, server, actualServer);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
