package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedClusterFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedClusterFluentAssert<S extends AbstractNamedClusterFluentAssert<S, A>, A extends NamedClusterFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedClusterFluentAssert}</code> to make assertions on actual NamedClusterFluent.
   * @param actual the NamedClusterFluent we want to make assertions on.
   */
  protected AbstractNamedClusterFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedClusterFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedClusterFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterFluent's cluster is equal to the given one.
   * @param cluster the given cluster to compare the actual NamedClusterFluent's cluster to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterFluent's cluster is not equal to the given one.
   */
  public S hasCluster(Cluster cluster) {
    // check that actual NamedClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cluster of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Cluster actualCluster = actual.getCluster();
    if (!Objects.areEqual(actualCluster, cluster)) {
      failWithMessage(assertjErrorMessage, actual, cluster, actualCluster);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterFluent's name is equal to the given one.
   * @param name the given name to compare the actual NamedClusterFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
