package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedClusterFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedClusterFluentImplAssert<S extends AbstractNamedClusterFluentImplAssert<S, A>, A extends NamedClusterFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedClusterFluentImplAssert}</code> to make assertions on actual NamedClusterFluentImpl.
   * @param actual the NamedClusterFluentImpl we want to make assertions on.
   */
  protected AbstractNamedClusterFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedClusterFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedClusterFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedClusterFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterFluentImpl's cluster is equal to the given one.
   * @param cluster the given cluster to compare the actual NamedClusterFluentImpl's cluster to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterFluentImpl's cluster is not equal to the given one.
   */
  public S hasCluster(Cluster cluster) {
    // check that actual NamedClusterFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cluster of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Cluster actualCluster = actual.getCluster();
    if (!Objects.areEqual(actualCluster, cluster)) {
      failWithMessage(assertjErrorMessage, actual, cluster, actualCluster);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual NamedClusterFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedClusterFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
