package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeDaemonEndpointsFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeDaemonEndpointsFluentAssert<S extends AbstractNodeDaemonEndpointsFluentAssert<S, A>, A extends NodeDaemonEndpointsFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeDaemonEndpointsFluentAssert}</code> to make assertions on actual NodeDaemonEndpointsFluent.
   * @param actual the NodeDaemonEndpointsFluent we want to make assertions on.
   */
  protected AbstractNodeDaemonEndpointsFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeDaemonEndpointsFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeDaemonEndpointsFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeDaemonEndpointsFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeDaemonEndpointsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeDaemonEndpointsFluent's kubeletEndpoint is equal to the given one.
   * @param kubeletEndpoint the given kubeletEndpoint to compare the actual NodeDaemonEndpointsFluent's kubeletEndpoint to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeDaemonEndpointsFluent's kubeletEndpoint is not equal to the given one.
   */
  public S hasKubeletEndpoint(DaemonEndpoint kubeletEndpoint) {
    // check that actual NodeDaemonEndpointsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kubeletEndpoint of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DaemonEndpoint actualKubeletEndpoint = actual.getKubeletEndpoint();
    if (!Objects.areEqual(actualKubeletEndpoint, kubeletEndpoint)) {
      failWithMessage(assertjErrorMessage, actual, kubeletEndpoint, actualKubeletEndpoint);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
