package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ObjectMetaFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractObjectMetaFluentImplAssert<S extends AbstractObjectMetaFluentImplAssert<S, A>, A extends ObjectMetaFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractObjectMetaFluentImplAssert}</code> to make assertions on actual ObjectMetaFluentImpl.
   * @param actual the ObjectMetaFluentImpl we want to make assertions on.
   */
  protected AbstractObjectMetaFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ObjectMetaFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual ObjectMetaFluentImpl's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual ObjectMetaFluentImpl's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's deletionGracePeriodSeconds is equal to the given one.
   * @param deletionGracePeriodSeconds the given deletionGracePeriodSeconds to compare the actual ObjectMetaFluentImpl's deletionGracePeriodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's deletionGracePeriodSeconds is not equal to the given one.
   */
  public S hasDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deletionGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualDeletionGracePeriodSeconds = actual.getDeletionGracePeriodSeconds();
    if (!Objects.areEqual(actualDeletionGracePeriodSeconds, deletionGracePeriodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, deletionGracePeriodSeconds, actualDeletionGracePeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's deletionTimestamp is equal to the given one.
   * @param deletionTimestamp the given deletionTimestamp to compare the actual ObjectMetaFluentImpl's deletionTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's deletionTimestamp is not equal to the given one.
   */
  public S hasDeletionTimestamp(String deletionTimestamp) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deletionTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDeletionTimestamp = actual.getDeletionTimestamp();
    if (!Objects.areEqual(actualDeletionTimestamp, deletionTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, deletionTimestamp, actualDeletionTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's generateName is equal to the given one.
   * @param generateName the given generateName to compare the actual ObjectMetaFluentImpl's generateName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's generateName is not equal to the given one.
   */
  public S hasGenerateName(String generateName) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generateName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualGenerateName = actual.getGenerateName();
    if (!Objects.areEqual(actualGenerateName, generateName)) {
      failWithMessage(assertjErrorMessage, actual, generateName, actualGenerateName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's generation is equal to the given one.
   * @param generation the given generation to compare the actual ObjectMetaFluentImpl's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's labels is equal to the given one.
   * @param labels the given labels to compare the actual ObjectMetaFluentImpl's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual ObjectMetaFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual ObjectMetaFluentImpl's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual ObjectMetaFluentImpl's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(String resourceVersion) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual ObjectMetaFluentImpl's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectMetaFluentImpl's uid is equal to the given one.
   * @param uid the given uid to compare the actual ObjectMetaFluentImpl's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMetaFluentImpl's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual ObjectMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
