package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ResourceRequirementsFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceRequirementsFluentAssert<S extends AbstractResourceRequirementsFluentAssert<S, A>, A extends ResourceRequirementsFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceRequirementsFluentAssert}</code> to make assertions on actual ResourceRequirementsFluent.
   * @param actual the ResourceRequirementsFluent we want to make assertions on.
   */
  protected AbstractResourceRequirementsFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ResourceRequirementsFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ResourceRequirementsFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ResourceRequirementsFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ResourceRequirementsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ResourceRequirementsFluent's limits is equal to the given one.
   * @param limits the given limits to compare the actual ResourceRequirementsFluent's limits to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ResourceRequirementsFluent's limits is not equal to the given one.
   */
  public S hasLimits(java.util.Map limits) {
    // check that actual ResourceRequirementsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting limits of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLimits = actual.getLimits();
    if (!Objects.areEqual(actualLimits, limits)) {
      failWithMessage(assertjErrorMessage, actual, limits, actualLimits);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ResourceRequirementsFluent's requests is equal to the given one.
   * @param requests the given requests to compare the actual ResourceRequirementsFluent's requests to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ResourceRequirementsFluent's requests is not equal to the given one.
   */
  public S hasRequests(java.util.Map requests) {
    // check that actual ResourceRequirementsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting requests of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualRequests = actual.getRequests();
    if (!Objects.areEqual(actualRequests, requests)) {
      failWithMessage(assertjErrorMessage, actual, requests, actualRequests);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
