package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SELinuxOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSELinuxOptionsAssert<S extends AbstractSELinuxOptionsAssert<S, A>, A extends SELinuxOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSELinuxOptionsAssert}</code> to make assertions on actual SELinuxOptions.
   * @param actual the SELinuxOptions we want to make assertions on.
   */
  protected AbstractSELinuxOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SELinuxOptions's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SELinuxOptions's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptions's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptions's level is equal to the given one.
   * @param level the given level to compare the actual SELinuxOptions's level to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptions's level is not equal to the given one.
   */
  public S hasLevel(String level) {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting level of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLevel = actual.getLevel();
    if (!Objects.areEqual(actualLevel, level)) {
      failWithMessage(assertjErrorMessage, actual, level, actualLevel);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptions's role is equal to the given one.
   * @param role the given role to compare the actual SELinuxOptions's role to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptions's role is not equal to the given one.
   */
  public S hasRole(String role) {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting role of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRole = actual.getRole();
    if (!Objects.areEqual(actualRole, role)) {
      failWithMessage(assertjErrorMessage, actual, role, actualRole);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptions's type is equal to the given one.
   * @param type the given type to compare the actual SELinuxOptions's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptions's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptions's user is equal to the given one.
   * @param user the given user to compare the actual SELinuxOptions's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptions's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual SELinuxOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
