package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecurityContextConstraints} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextConstraintsAssert<S extends AbstractSecurityContextConstraintsAssert<S, A>, A extends SecurityContextConstraints> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextConstraintsAssert}</code> to make assertions on actual SecurityContextConstraints.
   * @param actual the SecurityContextConstraints we want to make assertions on.
   */
  protected AbstractSecurityContextConstraintsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecurityContextConstraints's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecurityContextConstraints's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowHostDirVolumePlugin is equal to the given one.
   * @param allowHostDirVolumePlugin the given allowHostDirVolumePlugin to compare the actual SecurityContextConstraints's allowHostDirVolumePlugin to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's allowHostDirVolumePlugin is not equal to the given one.
   */
  public S hasAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting allowHostDirVolumePlugin of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualAllowHostDirVolumePlugin = actual.getAllowHostDirVolumePlugin();
    if (!Objects.areEqual(actualAllowHostDirVolumePlugin, allowHostDirVolumePlugin)) {
      failWithMessage(assertjErrorMessage, actual, allowHostDirVolumePlugin, actualAllowHostDirVolumePlugin);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowHostIPC is equal to the given one.
   * @param allowHostIPC the given allowHostIPC to compare the actual SecurityContextConstraints's allowHostIPC to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's allowHostIPC is not equal to the given one.
   */
  public S hasAllowHostIPC(Boolean allowHostIPC) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting allowHostIPC of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualAllowHostIPC = actual.getAllowHostIPC();
    if (!Objects.areEqual(actualAllowHostIPC, allowHostIPC)) {
      failWithMessage(assertjErrorMessage, actual, allowHostIPC, actualAllowHostIPC);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowHostNetwork is equal to the given one.
   * @param allowHostNetwork the given allowHostNetwork to compare the actual SecurityContextConstraints's allowHostNetwork to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's allowHostNetwork is not equal to the given one.
   */
  public S hasAllowHostNetwork(Boolean allowHostNetwork) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting allowHostNetwork of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualAllowHostNetwork = actual.getAllowHostNetwork();
    if (!Objects.areEqual(actualAllowHostNetwork, allowHostNetwork)) {
      failWithMessage(assertjErrorMessage, actual, allowHostNetwork, actualAllowHostNetwork);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowHostPID is equal to the given one.
   * @param allowHostPID the given allowHostPID to compare the actual SecurityContextConstraints's allowHostPID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's allowHostPID is not equal to the given one.
   */
  public S hasAllowHostPID(Boolean allowHostPID) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting allowHostPID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualAllowHostPID = actual.getAllowHostPID();
    if (!Objects.areEqual(actualAllowHostPID, allowHostPID)) {
      failWithMessage(assertjErrorMessage, actual, allowHostPID, actualAllowHostPID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowHostPorts is equal to the given one.
   * @param allowHostPorts the given allowHostPorts to compare the actual SecurityContextConstraints's allowHostPorts to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's allowHostPorts is not equal to the given one.
   */
  public S hasAllowHostPorts(Boolean allowHostPorts) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting allowHostPorts of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualAllowHostPorts = actual.getAllowHostPorts();
    if (!Objects.areEqual(actualAllowHostPorts, allowHostPorts)) {
      failWithMessage(assertjErrorMessage, actual, allowHostPorts, actualAllowHostPorts);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowPrivilegedContainer is equal to the given one.
   * @param allowPrivilegedContainer the given allowPrivilegedContainer to compare the actual SecurityContextConstraints's allowPrivilegedContainer to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's allowPrivilegedContainer is not equal to the given one.
   */
  public S hasAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting allowPrivilegedContainer of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualAllowPrivilegedContainer = actual.getAllowPrivilegedContainer();
    if (!Objects.areEqual(actualAllowPrivilegedContainer, allowPrivilegedContainer)) {
      failWithMessage(assertjErrorMessage, actual, allowPrivilegedContainer, actualAllowPrivilegedContainer);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowedCapabilities contains the given String elements.
   * @param allowedCapabilities the given elements that should be contained in actual SecurityContextConstraints's allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's allowedCapabilities does not contain all given String elements.
   */
  public S hasAllowedCapabilities(String... allowedCapabilities) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (allowedCapabilities == null) failWithMessage("Expecting allowedCapabilities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAllowedCapabilities(), allowedCapabilities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowedCapabilities contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param allowedCapabilities the given elements that should be contained in actual SecurityContextConstraints's allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's allowedCapabilities does not contain all given String elements.
   */
  public S hasOnlyAllowedCapabilities(String... allowedCapabilities) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (allowedCapabilities == null) failWithMessage("Expecting allowedCapabilities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getAllowedCapabilities(), allowedCapabilities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's allowedCapabilities does not contain the given String elements.
   *
   * @param allowedCapabilities the given elements that should not be in actual SecurityContextConstraints's allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's allowedCapabilities contains any given String elements.
   */
  public S doesNotHaveAllowedCapabilities(String... allowedCapabilities) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (allowedCapabilities == null) failWithMessage("Expecting allowedCapabilities parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getAllowedCapabilities(), allowedCapabilities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints has no allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's allowedCapabilities is not empty.
   */
  public S hasNoAllowedCapabilities() {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allowedCapabilities but had :\n  <%s>";
    
    // check
    if (actual.getAllowedCapabilities().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAllowedCapabilities());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SecurityContextConstraints's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual SecurityContextConstraints's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContextConstraints.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's fsGroup is equal to the given one.
   * @param fsGroup the given fsGroup to compare the actual SecurityContextConstraints's fsGroup to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's fsGroup is not equal to the given one.
   */
  public S hasFsGroup(FSGroupStrategyOptions fsGroup) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FSGroupStrategyOptions actualFsGroup = actual.getFsGroup();
    if (!Objects.areEqual(actualFsGroup, fsGroup)) {
      failWithMessage(assertjErrorMessage, actual, fsGroup, actualFsGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's groups contains the given String elements.
   * @param groups the given elements that should be contained in actual SecurityContextConstraints's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's groups does not contain all given String elements.
   */
  public S hasGroups(String... groups) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's groups contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param groups the given elements that should be contained in actual SecurityContextConstraints's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's groups does not contain all given String elements.
   */
  public S hasOnlyGroups(String... groups) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's groups does not contain the given String elements.
   *
   * @param groups the given elements that should not be in actual SecurityContextConstraints's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's groups contains any given String elements.
   */
  public S doesNotHaveGroups(String... groups) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints has no groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's groups is not empty.
   */
  public S hasNoGroups() {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have groups but had :\n  <%s>";
    
    // check
    if (actual.getGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SecurityContextConstraints's kind is equal to the given one.
   * @param kind the given kind to compare the actual SecurityContextConstraints's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual SecurityContextConstraints's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's priority is equal to the given one.
   * @param priority the given priority to compare the actual SecurityContextConstraints's priority to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's priority is not equal to the given one.
   */
  public S hasPriority(Integer priority) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting priority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPriority = actual.getPriority();
    if (!Objects.areEqual(actualPriority, priority)) {
      failWithMessage(assertjErrorMessage, actual, priority, actualPriority);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual SecurityContextConstraints's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(RunAsUserStrategyOptions runAsUser) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RunAsUserStrategyOptions actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's seLinuxContext is equal to the given one.
   * @param seLinuxContext the given seLinuxContext to compare the actual SecurityContextConstraints's seLinuxContext to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's seLinuxContext is not equal to the given one.
   */
  public S hasSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting seLinuxContext of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxContextStrategyOptions actualSeLinuxContext = actual.getSeLinuxContext();
    if (!Objects.areEqual(actualSeLinuxContext, seLinuxContext)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxContext, actualSeLinuxContext);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's supplementalGroups is equal to the given one.
   * @param supplementalGroups the given supplementalGroups to compare the actual SecurityContextConstraints's supplementalGroups to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's supplementalGroups is not equal to the given one.
   */
  public S hasSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting supplementalGroups of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SupplementalGroupsStrategyOptions actualSupplementalGroups = actual.getSupplementalGroups();
    if (!Objects.areEqual(actualSupplementalGroups, supplementalGroups)) {
      failWithMessage(assertjErrorMessage, actual, supplementalGroups, actualSupplementalGroups);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's users contains the given String elements.
   * @param users the given elements that should be contained in actual SecurityContextConstraints's users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's users does not contain all given String elements.
   */
  public S hasUsers(String... users) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's users contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param users the given elements that should be contained in actual SecurityContextConstraints's users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's users does not contain all given String elements.
   */
  public S hasOnlyUsers(String... users) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints's users does not contain the given String elements.
   *
   * @param users the given elements that should not be in actual SecurityContextConstraints's users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's users contains any given String elements.
   */
  public S doesNotHaveUsers(String... users) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraints has no users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraints's users is not empty.
   */
  public S hasNoUsers() {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have users but had :\n  <%s>";
    
    // check
    if (actual.getUsers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUsers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
