package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TypeMetaFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTypeMetaFluentImplAssert<S extends AbstractTypeMetaFluentImplAssert<S, A>, A extends TypeMetaFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTypeMetaFluentImplAssert}</code> to make assertions on actual TypeMetaFluentImpl.
   * @param actual the TypeMetaFluentImpl we want to make assertions on.
   */
  protected AbstractTypeMetaFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TypeMetaFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TypeMetaFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeMetaFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TypeMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeMetaFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual TypeMetaFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeMetaFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual TypeMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeMetaFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual TypeMetaFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeMetaFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual TypeMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
