package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link WatchEvent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractWatchEventAssert<S extends AbstractWatchEventAssert<S, A>, A extends WatchEvent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWatchEventAssert}</code> to make assertions on actual WatchEvent.
   * @param actual the WatchEvent we want to make assertions on.
   */
  protected AbstractWatchEventAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WatchEvent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual WatchEvent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WatchEvent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual WatchEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WatchEvent's object is equal to the given one.
   * @param object the given object to compare the actual WatchEvent's object to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WatchEvent's object is not equal to the given one.
   */
  public S hasObject(HasMetadata object) {
    // check that actual WatchEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting object of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HasMetadata actualObject = actual.getObject();
    if (!Objects.areEqual(actualObject, object)) {
      failWithMessage(assertjErrorMessage, actual, object, actualObject);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WatchEvent's type is equal to the given one.
   * @param type the given type to compare the actual WatchEvent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WatchEvent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual WatchEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
