package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentStrategyAssert<S extends AbstractDeploymentStrategyAssert<S, A>, A extends DeploymentStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentStrategyAssert}</code> to make assertions on actual DeploymentStrategy.
   * @param actual the DeploymentStrategy we want to make assertions on.
   */
  protected AbstractDeploymentStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentStrategy's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentStrategy's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategy's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStrategy's rollingUpdate is equal to the given one.
   * @param rollingUpdate the given rollingUpdate to compare the actual DeploymentStrategy's rollingUpdate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategy's rollingUpdate is not equal to the given one.
   */
  public S hasRollingUpdate(RollingUpdateDeployment rollingUpdate) {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rollingUpdate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RollingUpdateDeployment actualRollingUpdate = actual.getRollingUpdate();
    if (!Objects.areEqual(actualRollingUpdate, rollingUpdate)) {
      failWithMessage(assertjErrorMessage, actual, rollingUpdate, actualRollingUpdate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStrategy's type is equal to the given one.
   * @param type the given type to compare the actual DeploymentStrategy's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategy's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
