package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IngressBackendFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressBackendFluentImplAssert<S extends AbstractIngressBackendFluentImplAssert<S, A>, A extends IngressBackendFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressBackendFluentImplAssert}</code> to make assertions on actual IngressBackendFluentImpl.
   * @param actual the IngressBackendFluentImpl we want to make assertions on.
   */
  protected AbstractIngressBackendFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IngressBackendFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IngressBackendFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressBackendFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IngressBackendFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressBackendFluentImpl's serviceName is equal to the given one.
   * @param serviceName the given serviceName to compare the actual IngressBackendFluentImpl's serviceName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressBackendFluentImpl's serviceName is not equal to the given one.
   */
  public S hasServiceName(String serviceName) {
    // check that actual IngressBackendFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting serviceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServiceName = actual.getServiceName();
    if (!Objects.areEqual(actualServiceName, serviceName)) {
      failWithMessage(assertjErrorMessage, actual, serviceName, actualServiceName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressBackendFluentImpl's servicePort is equal to the given one.
   * @param servicePort the given servicePort to compare the actual IngressBackendFluentImpl's servicePort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressBackendFluentImpl's servicePort is not equal to the given one.
   */
  public S hasServicePort(io.fabric8.kubernetes.api.model.IntOrString servicePort) {
    // check that actual IngressBackendFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting servicePort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.IntOrString actualServicePort = actual.getServicePort();
    if (!Objects.areEqual(actualServicePort, servicePort)) {
      failWithMessage(assertjErrorMessage, actual, servicePort, actualServicePort);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
