package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IngressStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressStatusAssert<S extends AbstractIngressStatusAssert<S, A>, A extends IngressStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressStatusAssert}</code> to make assertions on actual IngressStatus.
   * @param actual the IngressStatus we want to make assertions on.
   */
  protected AbstractIngressStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IngressStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IngressStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IngressStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressStatus's loadBalancer is equal to the given one.
   * @param loadBalancer the given loadBalancer to compare the actual IngressStatus's loadBalancer to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressStatus's loadBalancer is not equal to the given one.
   */
  public S hasLoadBalancer(io.fabric8.kubernetes.api.model.LoadBalancerStatus loadBalancer) {
    // check that actual IngressStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting loadBalancer of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LoadBalancerStatus actualLoadBalancer = actual.getLoadBalancer();
    if (!Objects.areEqual(actualLoadBalancer, loadBalancer)) {
      failWithMessage(assertjErrorMessage, actual, loadBalancer, actualLoadBalancer);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
