package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SubresourceReferenceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubresourceReferenceFluentImplAssert<S extends AbstractSubresourceReferenceFluentImplAssert<S, A>, A extends SubresourceReferenceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubresourceReferenceFluentImplAssert}</code> to make assertions on actual SubresourceReferenceFluentImpl.
   * @param actual the SubresourceReferenceFluentImpl we want to make assertions on.
   */
  protected AbstractSubresourceReferenceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SubresourceReferenceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SubresourceReferenceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubresourceReferenceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SubresourceReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubresourceReferenceFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual SubresourceReferenceFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubresourceReferenceFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual SubresourceReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubresourceReferenceFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual SubresourceReferenceFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubresourceReferenceFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual SubresourceReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubresourceReferenceFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual SubresourceReferenceFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubresourceReferenceFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual SubresourceReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubresourceReferenceFluentImpl's subresource is equal to the given one.
   * @param subresource the given subresource to compare the actual SubresourceReferenceFluentImpl's subresource to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubresourceReferenceFluentImpl's subresource is not equal to the given one.
   */
  public S hasSubresource(String subresource) {
    // check that actual SubresourceReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting subresource of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSubresource = actual.getSubresource();
    if (!Objects.areEqual(actualSubresource, subresource)) {
      failWithMessage(assertjErrorMessage, actual, subresource, actualSubresource);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
