package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ThirdPartyResource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractThirdPartyResourceAssert<S extends AbstractThirdPartyResourceAssert<S, A>, A extends ThirdPartyResource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractThirdPartyResourceAssert}</code> to make assertions on actual ThirdPartyResource.
   * @param actual the ThirdPartyResource we want to make assertions on.
   */
  protected AbstractThirdPartyResourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ThirdPartyResource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ThirdPartyResource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ThirdPartyResource's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResource's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ThirdPartyResource.ApiVersion apiVersion) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ThirdPartyResource.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource's description is equal to the given one.
   * @param description the given description to compare the actual ThirdPartyResource's description to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResource's description is not equal to the given one.
   */
  public S hasDescription(String description) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting description of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDescription = actual.getDescription();
    if (!Objects.areEqual(actualDescription, description)) {
      failWithMessage(assertjErrorMessage, actual, description, actualDescription);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource's kind is equal to the given one.
   * @param kind the given kind to compare the actual ThirdPartyResource's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResource's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ThirdPartyResource's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResource's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource's versions contains the given APIVersion elements.
   * @param versions the given elements that should be contained in actual ThirdPartyResource's versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResource's versions does not contain all given APIVersion elements.
   */
  public S hasVersions(APIVersion... versions) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // check that given APIVersion varargs is not null.
    if (versions == null) failWithMessage("Expecting versions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVersions(), versions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource's versions contains <b>only<b> the given APIVersion elements and nothing else in whatever order.
   * @param versions the given elements that should be contained in actual ThirdPartyResource's versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResource's versions does not contain all given APIVersion elements.
   */
  public S hasOnlyVersions(APIVersion... versions) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // check that given APIVersion varargs is not null.
    if (versions == null) failWithMessage("Expecting versions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getVersions(), versions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource's versions does not contain the given APIVersion elements.
   *
   * @param versions the given elements that should not be in actual ThirdPartyResource's versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResource's versions contains any given APIVersion elements.
   */
  public S doesNotHaveVersions(APIVersion... versions) {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // check that given APIVersion varargs is not null.
    if (versions == null) failWithMessage("Expecting versions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getVersions(), versions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResource has no versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResource's versions is not empty.
   */
  public S hasNoVersions() {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have versions but had :\n  <%s>";
    
    // check
    if (actual.getVersions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVersions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
