package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentTriggerPolicyFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentTriggerPolicyFluentImplAssert<S extends AbstractDeploymentTriggerPolicyFluentImplAssert<S, A>, A extends DeploymentTriggerPolicyFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentTriggerPolicyFluentImplAssert}</code> to make assertions on actual DeploymentTriggerPolicyFluentImpl.
   * @param actual the DeploymentTriggerPolicyFluentImpl we want to make assertions on.
   */
  protected AbstractDeploymentTriggerPolicyFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentTriggerPolicyFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentTriggerPolicyFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentTriggerPolicyFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentTriggerPolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentTriggerPolicyFluentImpl's imageChangeParams is equal to the given one.
   * @param imageChangeParams the given imageChangeParams to compare the actual DeploymentTriggerPolicyFluentImpl's imageChangeParams to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentTriggerPolicyFluentImpl's imageChangeParams is not equal to the given one.
   */
  public S hasImageChangeParams(DeploymentTriggerImageChangeParams imageChangeParams) {
    // check that actual DeploymentTriggerPolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting imageChangeParams of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentTriggerImageChangeParams actualImageChangeParams = actual.getImageChangeParams();
    if (!Objects.areEqual(actualImageChangeParams, imageChangeParams)) {
      failWithMessage(assertjErrorMessage, actual, imageChangeParams, actualImageChangeParams);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentTriggerPolicyFluentImpl's type is equal to the given one.
   * @param type the given type to compare the actual DeploymentTriggerPolicyFluentImpl's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentTriggerPolicyFluentImpl's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual DeploymentTriggerPolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
