package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ImageFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageFluentAssert<S extends AbstractImageFluentAssert<S, A>, A extends ImageFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageFluentAssert}</code> to make assertions on actual ImageFluent.
   * @param actual the ImageFluent we want to make assertions on.
   */
  protected AbstractImageFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ImageFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ImageFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ImageFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Image.ApiVersion apiVersion) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Image.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluent's dockerImageManifest is equal to the given one.
   * @param dockerImageManifest the given dockerImageManifest to compare the actual ImageFluent's dockerImageManifest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's dockerImageManifest is not equal to the given one.
   */
  public S hasDockerImageManifest(String dockerImageManifest) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageManifest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageManifest = actual.getDockerImageManifest();
    if (!Objects.areEqual(actualDockerImageManifest, dockerImageManifest)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageManifest, actualDockerImageManifest);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluent's dockerImageMetadata is equal to the given one.
   * @param dockerImageMetadata the given dockerImageMetadata to compare the actual ImageFluent's dockerImageMetadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's dockerImageMetadata is not equal to the given one.
   */
  public S hasDockerImageMetadata(io.fabric8.kubernetes.api.model.HasMetadata dockerImageMetadata) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageMetadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.HasMetadata actualDockerImageMetadata = actual.getDockerImageMetadata();
    if (!Objects.areEqual(actualDockerImageMetadata, dockerImageMetadata)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageMetadata, actualDockerImageMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluent's dockerImageMetadataVersion is equal to the given one.
   * @param dockerImageMetadataVersion the given dockerImageMetadataVersion to compare the actual ImageFluent's dockerImageMetadataVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's dockerImageMetadataVersion is not equal to the given one.
   */
  public S hasDockerImageMetadataVersion(String dockerImageMetadataVersion) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageMetadataVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageMetadataVersion = actual.getDockerImageMetadataVersion();
    if (!Objects.areEqual(actualDockerImageMetadataVersion, dockerImageMetadataVersion)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageMetadataVersion, actualDockerImageMetadataVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluent's dockerImageReference is equal to the given one.
   * @param dockerImageReference the given dockerImageReference to compare the actual ImageFluent's dockerImageReference to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's dockerImageReference is not equal to the given one.
   */
  public S hasDockerImageReference(String dockerImageReference) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageReference of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageReference = actual.getDockerImageReference();
    if (!Objects.areEqual(actualDockerImageReference, dockerImageReference)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageReference, actualDockerImageReference);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual ImageFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ImageFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
