package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ImageStreamSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageStreamSpecFluentAssert<S extends AbstractImageStreamSpecFluentAssert<S, A>, A extends ImageStreamSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageStreamSpecFluentAssert}</code> to make assertions on actual ImageStreamSpecFluent.
   * @param actual the ImageStreamSpecFluent we want to make assertions on.
   */
  protected AbstractImageStreamSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ImageStreamSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ImageStreamSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageStreamSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ImageStreamSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluent's dockerImageRepository is equal to the given one.
   * @param dockerImageRepository the given dockerImageRepository to compare the actual ImageStreamSpecFluent's dockerImageRepository to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageStreamSpecFluent's dockerImageRepository is not equal to the given one.
   */
  public S hasDockerImageRepository(String dockerImageRepository) {
    // check that actual ImageStreamSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageRepository of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageRepository = actual.getDockerImageRepository();
    if (!Objects.areEqual(actualDockerImageRepository, dockerImageRepository)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageRepository, actualDockerImageRepository);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluent's tags contains the given NamedTagReference elements.
   * @param tags the given elements that should be contained in actual ImageStreamSpecFluent's tags.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageStreamSpecFluent's tags does not contain all given NamedTagReference elements.
   */
  public S hasTags(NamedTagReference... tags) {
    // check that actual ImageStreamSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedTagReference varargs is not null.
    if (tags == null) failWithMessage("Expecting tags parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTags(), tags);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluent's tags contains <b>only<b> the given NamedTagReference elements and nothing else in whatever order.
   * @param tags the given elements that should be contained in actual ImageStreamSpecFluent's tags.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageStreamSpecFluent's tags does not contain all given NamedTagReference elements.
   */
  public S hasOnlyTags(NamedTagReference... tags) {
    // check that actual ImageStreamSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedTagReference varargs is not null.
    if (tags == null) failWithMessage("Expecting tags parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getTags(), tags);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluent's tags does not contain the given NamedTagReference elements.
   *
   * @param tags the given elements that should not be in actual ImageStreamSpecFluent's tags.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageStreamSpecFluent's tags contains any given NamedTagReference elements.
   */
  public S doesNotHaveTags(NamedTagReference... tags) {
    // check that actual ImageStreamSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedTagReference varargs is not null.
    if (tags == null) failWithMessage("Expecting tags parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getTags(), tags);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluent has no tags.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageStreamSpecFluent's tags is not empty.
   */
  public S hasNoTags() {
    // check that actual ImageStreamSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tags but had :\n  <%s>";
    
    // check
    if (actual.getTags().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTags());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
