package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PolicyFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPolicyFluentImplAssert<S extends AbstractPolicyFluentImplAssert<S, A>, A extends PolicyFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPolicyFluentImplAssert}</code> to make assertions on actual PolicyFluentImpl.
   * @param actual the PolicyFluentImpl we want to make assertions on.
   */
  protected AbstractPolicyFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PolicyFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PolicyFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual PolicyFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Policy.ApiVersion apiVersion) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Policy.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual PolicyFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl's lastModified is equal to the given one.
   * @param lastModified the given lastModified to compare the actual PolicyFluentImpl's lastModified to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyFluentImpl's lastModified is not equal to the given one.
   */
  public S hasLastModified(String lastModified) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastModified of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastModified = actual.getLastModified();
    if (!Objects.areEqual(actualLastModified, lastModified)) {
      failWithMessage(assertjErrorMessage, actual, lastModified, actualLastModified);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual PolicyFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl's roles contains the given NamedRole elements.
   * @param roles the given elements that should be contained in actual PolicyFluentImpl's roles.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyFluentImpl's roles does not contain all given NamedRole elements.
   */
  public S hasRoles(NamedRole... roles) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedRole varargs is not null.
    if (roles == null) failWithMessage("Expecting roles parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRoles(), roles);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl's roles contains <b>only<b> the given NamedRole elements and nothing else in whatever order.
   * @param roles the given elements that should be contained in actual PolicyFluentImpl's roles.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyFluentImpl's roles does not contain all given NamedRole elements.
   */
  public S hasOnlyRoles(NamedRole... roles) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedRole varargs is not null.
    if (roles == null) failWithMessage("Expecting roles parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getRoles(), roles);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl's roles does not contain the given NamedRole elements.
   *
   * @param roles the given elements that should not be in actual PolicyFluentImpl's roles.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyFluentImpl's roles contains any given NamedRole elements.
   */
  public S doesNotHaveRoles(NamedRole... roles) {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedRole varargs is not null.
    if (roles == null) failWithMessage("Expecting roles parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getRoles(), roles);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyFluentImpl has no roles.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyFluentImpl's roles is not empty.
   */
  public S hasNoRoles() {
    // check that actual PolicyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have roles but had :\n  <%s>";
    
    // check
    if (actual.getRoles().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRoles());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
